/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.request.retry;

import com.aftership.sdk.request.retry.RetryCondition;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Response;

public class RetryInterceptor
implements Interceptor {
    private long initialDelay;
    private long maxDelay;
    private int maxRetries;
    private double backoffMultiplier;
    private double jitterFactor;
    private List<RetryCondition> retryConditions;

    public RetryInterceptor(long initialDelay, long maxDelay, int maxRetries, double backoffMultiplier, double jitterFactor, List<RetryCondition> retryConditions) {
        this.initialDelay = initialDelay;
        this.maxDelay = maxDelay;
        this.maxRetries = maxRetries;
        this.backoffMultiplier = backoffMultiplier;
        this.jitterFactor = jitterFactor;
        this.retryConditions = retryConditions;
    }

    public RetryInterceptor(long initialDelay, long maxDelay, int maxRetries, List<RetryCondition> retryConditions) {
        this(initialDelay, maxDelay, maxRetries, 1.6, 0.2, retryConditions);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.retryWithBackoff(chain);
    }

    protected Response retryWithBackoff(Interceptor.Chain chain) throws IOException {
        Response response = null;
        IOException exception = null;
        for (int retries = 0; retries <= this.maxRetries; ++retries) {
            try {
                if (response != null) {
                    response.close();
                }
                if ((response = chain.proceed(chain.request())).isSuccessful()) {
                    return response;
                }
            }
            catch (IOException e) {
                exception = e;
            }
            if (!this.shouldRetry(response, exception)) break;
            this.waitForDelay(retries);
        }
        if (exception != null) {
            throw exception;
        }
        return response;
    }

    private boolean shouldRetry(Response response, IOException exception) {
        for (RetryCondition condition : this.retryConditions) {
            if (!condition.shouldRetry(response, exception)) continue;
            return true;
        }
        return false;
    }

    private void waitForDelay(int retries) {
        long delay = this.backoff(retries);
        try {
            TimeUnit.MILLISECONDS.sleep(delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private long backoff(int retries) {
        double jitter;
        long delay = (long)((double)this.initialDelay * Math.pow(this.backoffMultiplier, retries));
        long finalDelay = (long)((double)delay + (jitter = this.jitterFactor * (double)delay * (Math.random() - 0.5) * 2.0));
        if (finalDelay > this.maxDelay) {
            finalDelay = this.maxDelay;
        }
        return finalDelay;
    }
}

