/*
 * Decompiled with CFR 0.152.
 */
package com.aftership.sdk.utils;

import com.aftership.sdk.utils.DateUtils;
import com.aftership.sdk.utils.StrUtils;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Optional;

public final class JsonUtils {
    private static final Gson INSTANCE = JsonUtils.createGson();

    private JsonUtils() {
    }

    public static final Gson getGson() {
        return INSTANCE;
    }

    private static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new GsonDateDeSerializer());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder.create();
    }

    private static class GsonDateDeSerializer
    implements JsonDeserializer<Date> {
        private GsonDateDeSerializer() {
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            String dateString = json.getAsJsonPrimitive().getAsString();
            return this.parseDate(dateString);
        }

        private Date parseDate(String dateString) {
            String[] formats;
            if (StrUtils.isBlank(dateString)) {
                return null;
            }
            for (String item : formats = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ssXXX"}) {
                Optional<Date> optionalDate = DateUtils.parse(item, dateString);
                if (!optionalDate.isPresent()) continue;
                return optionalDate.get();
            }
            return null;
        }
    }
}

