/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.ChainContext;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainEvent;
import com.agentsflex.core.chain.ChainEventListener;
import com.agentsflex.core.chain.ChainException;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.ChainOutputListener;
import com.agentsflex.core.chain.ChainStatus;
import com.agentsflex.core.chain.EdgeCondition;
import com.agentsflex.core.chain.InputParameter;
import com.agentsflex.core.chain.NodeCondition;
import com.agentsflex.core.chain.NodeContext;
import com.agentsflex.core.chain.event.OnChainEndEvent;
import com.agentsflex.core.chain.event.OnChainStartEvent;
import com.agentsflex.core.chain.event.OnErrorEvent;
import com.agentsflex.core.chain.event.OnNodeEndEvent;
import com.agentsflex.core.chain.event.OnNodeStartEvent;
import com.agentsflex.core.chain.event.OnStatusChangeEvent;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.MapUtil;
import com.agentsflex.core.util.NamedThreadPools;
import com.agentsflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

public class Chain
extends ChainNode {
    protected Map<Class<?>, List<ChainEventListener>> eventListeners = new HashMap(0);
    protected Map<String, Object> executeResult = null;
    protected List<ChainOutputListener> outputListeners = new ArrayList<ChainOutputListener>();
    protected List<ChainNode> nodes;
    protected List<ChainEdge> edges;
    protected ChainStatus status = ChainStatus.READY;
    protected String message;
    protected Chain parent;
    protected List<Chain> children;
    protected ExecutorService asyncNodeExecutors = NamedThreadPools.newFixedThreadPool("chain-executor");
    protected Map<String, NodeContext> nodeContexts = new ConcurrentHashMap<String, NodeContext>();
    protected Exception exception;

    public Chain() {
        this.id = UUID.randomUUID().toString();
    }

    public Map<Class<?>, List<ChainEventListener>> getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(Map<Class<?>, List<ChainEventListener>> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public synchronized void addEventListener(Class<? extends ChainEvent> eventClass, ChainEventListener listener) {
        List chainEventListeners = this.eventListeners.computeIfAbsent(eventClass, k -> new ArrayList());
        chainEventListeners.add(listener);
    }

    public synchronized void addEventListener(ChainEventListener listener) {
        List chainEventListeners = this.eventListeners.computeIfAbsent(ChainEvent.class, k -> new ArrayList());
        chainEventListeners.add(listener);
    }

    public synchronized void removeEventListener(ChainEventListener listener) {
        for (List<ChainEventListener> list : this.eventListeners.values()) {
            list.removeIf(item -> item == listener);
        }
    }

    public synchronized void removeEventListener(Class<? extends ChainEvent> eventClass, ChainEventListener listener) {
        List<ChainEventListener> list = this.eventListeners.get(eventClass);
        if (list != null && !list.isEmpty()) {
            list.removeIf(item -> item == listener);
        }
    }

    public List<ChainOutputListener> getOutputListeners() {
        return this.outputListeners;
    }

    public void setOutputListeners(List<ChainOutputListener> outputListeners) {
        this.outputListeners = outputListeners;
    }

    public void addOutputListener(ChainOutputListener outputListener) {
        if (this.outputListeners == null) {
            this.outputListeners = new ArrayList<ChainOutputListener>();
        }
        this.outputListeners.add(outputListener);
    }

    public List<ChainNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<ChainNode> chainNodes) {
        this.nodes = chainNodes;
    }

    public void addNode(ChainNode chainNode) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<ChainNode>();
        }
        if (chainNode instanceof ChainEventListener) {
            this.addEventListener((ChainEventListener)((Object)chainNode));
        }
        if (chainNode.getId() == null) {
            chainNode.setId(UUID.randomUUID().toString());
        }
        if (chainNode instanceof Chain) {
            ((Chain)chainNode).parent = this;
            this.addChild((Chain)chainNode);
        }
        this.nodes.add(chainNode);
    }

    private void addChild(Chain child) {
        if (this.children == null) {
            this.children = new ArrayList<Chain>();
        }
        this.children.add(child);
    }

    public ChainStatus getStatus() {
        return this.status;
    }

    public void setStatus(ChainStatus status) {
        ChainStatus before = this.status;
        this.status = status;
        if (before != status) {
            this.notifyEvent(new OnStatusChangeEvent(this, this.status, before));
        }
    }

    public Chain getParent() {
        return this.parent;
    }

    public void setParent(Chain parent) {
        this.parent = parent;
    }

    public List<Chain> getChildren() {
        return this.children;
    }

    public void setChildren(List<Chain> children) {
        this.children = children;
    }

    public void notifyEvent(ChainEvent event) {
        for (Map.Entry<Class<?>, List<ChainEventListener>> entry : this.eventListeners.entrySet()) {
            if (!entry.getKey().isInstance(event)) continue;
            for (ChainEventListener chainEventListener : entry.getValue()) {
                chainEventListener.onEvent(event, this);
            }
        }
        if (this.parent != null) {
            this.parent.notifyEvent(event);
        }
    }

    public Object get(String key) {
        return this.memory.get(key);
    }

    public Object getGlobal(String key) {
        return this.memory.get(key);
    }

    @Override
    protected Map<String, Object> execute(Chain parent) {
        this.execute(parent.getMemory().getAll());
        return this.memory.getAll();
    }

    public void execute(Map<String, Object> variables) {
        this.runInLifeCycle(variables, this::executeInternal);
    }

    public Map<String, Object> executeForResult(Map<String, Object> variables) {
        this.runInLifeCycle(variables, this::executeInternal);
        if (this.status == ChainStatus.FINISHED_ABNORMAL) {
            if (this.exception != null) {
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                throw new ChainException(this.exception);
            }
            if (this.message == null) {
                this.message = "Chain execute error";
            }
            throw new ChainException(this.message);
        }
        return this.executeResult;
    }

    public List<InputParameter> getInputParameters() {
        List<ChainNode> startNodes = this.getStartNodes();
        if (startNodes == null || startNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InputParameter> inputParameters = new ArrayList<InputParameter>();
        for (ChainNode node : startNodes) {
            List<InputParameter> chainInputParameters;
            if (node instanceof BaseNode) {
                List<InputParameter> nodeInputParameters = ((BaseNode)node).getInputParameters();
                if (nodeInputParameters == null) continue;
                inputParameters.addAll(nodeInputParameters);
                continue;
            }
            if (!(node instanceof Chain) || (chainInputParameters = ((Chain)node).getInputParameters()) == null) continue;
            inputParameters.addAll(chainInputParameters);
        }
        return inputParameters;
    }

    public NodeContext getNodeContext(String nodeId) {
        return MapUtil.computeIfAbsent(this.nodeContexts, nodeId, k -> new NodeContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal() {
        List<ChainNode> currentNodes = this.getStartNodes();
        if (currentNodes == null || currentNodes.isEmpty()) {
            return;
        }
        ArrayList<ExecuteNode> waitingExecuteNodes = new ArrayList<ExecuteNode>();
        for (ChainNode currentNode : currentNodes) {
            waitingExecuteNodes.add(new ExecuteNode(currentNode, null, ""));
        }
        while (CollectionUtil.hasItems(waitingExecuteNodes)) {
            ChainNode currentNode;
            block15: {
                ExecuteNode executeNode = (ExecuteNode)waitingExecuteNodes.remove(0);
                currentNode = executeNode.currentNode;
                NodeContext nodeContext = this.getNodeContext(currentNode.getId());
                try {
                    this.onNodeExecuteBefore(nodeContext);
                    nodeContext.recordTrigger(executeNode);
                    NodeCondition nodeCondition = currentNode.getCondition();
                    if (nodeCondition != null && !nodeCondition.check(this, nodeContext)) continue;
                    Map<String, Object> executeResult = null;
                    try {
                        ChainContext.setNode(currentNode);
                        this.notifyEvent(new OnNodeStartEvent(this, currentNode));
                        if (this.getStatus() != ChainStatus.RUNNING) break;
                        this.onNodeExecuteStart(nodeContext);
                        nodeContext.recordExecute(executeNode);
                        executeResult = this.executeNode(currentNode);
                        this.executeResult = executeResult;
                    }
                    finally {
                        this.onNodeExecuteEnd(nodeContext);
                        ChainContext.clearNode();
                        this.notifyEvent(new OnNodeEndEvent(this, currentNode, executeResult));
                    }
                    if (executeResult == null || executeResult.isEmpty()) break block15;
                    executeResult.forEach((s, o) -> this.memory.put(currentNode.id + "." + s, o));
                }
                finally {
                    this.onNodeExecuteAfter(nodeContext);
                    continue;
                }
            }
            if (this.getStatus() != ChainStatus.RUNNING) break;
            List<ChainEdge> outwardEdges = currentNode.getOutwardEdges();
            if (!CollectionUtil.hasItems(outwardEdges)) continue;
            for (ChainEdge chainEdge : outwardEdges) {
                ChainNode nextNode = this.getNodeById(chainEdge.getTarget());
                if (nextNode == null) continue;
                EdgeCondition condition = chainEdge.getCondition();
                if (condition == null) {
                    waitingExecuteNodes.add(new ExecuteNode(nextNode, currentNode, chainEdge.getId()));
                    continue;
                }
                if (!condition.check(this, chainEdge)) continue;
                waitingExecuteNodes.add(new ExecuteNode(nextNode, currentNode, chainEdge.getId()));
            }
        }
    }

    protected void onNodeExecuteAfter(NodeContext nodeContext) {
    }

    protected void onNodeExecuteEnd(NodeContext nodeContext) {
    }

    protected void onNodeExecuteStart(NodeContext nodeContext) {
    }

    protected void onNodeExecuteBefore(NodeContext nodeContext) {
    }

    private Map<String, Object> executeNode(ChainNode currentNode) {
        Map<String, Object> executeResult = null;
        if (currentNode.isAsync()) {
            Chain currentChain = ChainContext.getCurrentChain();
            this.asyncNodeExecutors.execute(() -> {
                try {
                    ChainContext.setChain(currentChain);
                    ChainContext.setNode(currentNode);
                    currentNode.execute(this);
                }
                finally {
                    ChainContext.clearNode();
                    ChainContext.clearChain();
                }
            });
        } else {
            executeResult = currentNode.execute(this);
        }
        return executeResult;
    }

    private List<ChainNode> getStartNodes() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return null;
        }
        ArrayList<ChainNode> nodes = new ArrayList<ChainNode>();
        for (ChainNode node : this.nodes) {
            if (!CollectionUtil.noItems(node.getInwardEdges())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private ChainNode getNodeById(String id) {
        if (id == null || StringUtil.noText(id)) {
            return null;
        }
        for (ChainNode node : this.nodes) {
            if (!id.equals(node.getId())) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInLifeCycle(Map<String, Object> variables, Runnable runnable) {
        if (variables != null) {
            this.memory.putAll(variables);
        }
        try {
            ChainContext.setChain(this);
            this.notifyEvent(new OnChainStartEvent(this));
            try {
                this.setStatus(ChainStatus.RUNNING);
                runnable.run();
            }
            catch (Exception e) {
                this.exception = e;
                this.setStatus(ChainStatus.ERROR);
                this.notifyEvent(new OnErrorEvent(this, e));
            }
            if (this.status == ChainStatus.RUNNING) {
                this.setStatus(ChainStatus.FINISHED_NORMAL);
            } else if (this.status == ChainStatus.ERROR) {
                this.setStatus(ChainStatus.FINISHED_ABNORMAL);
            }
        }
        finally {
            ChainContext.clearChain();
            this.notifyEvent(new OnChainEndEvent(this));
        }
    }

    private void notifyOutput(ChainNode node, Object response) {
        for (ChainOutputListener inputListener : this.outputListeners) {
            inputListener.onOutput(this, node, response);
        }
        if (this.parent != null) {
            this.parent.notifyOutput(node, response);
        }
    }

    public void stopNormal(String message) {
        this.message = message;
        this.setStatus(ChainStatus.FINISHED_NORMAL);
    }

    public void stopError(String message) {
        this.message = message;
        this.setStatus(ChainStatus.FINISHED_ABNORMAL);
    }

    public void output(ChainNode node, Object response) {
        this.notifyOutput(node, response);
    }

    public String getMessage() {
        return this.message;
    }

    public List<ChainEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<ChainEdge> edges) {
        this.edges = edges;
    }

    public void addEdge(ChainEdge edge) {
        if (this.edges == null) {
            this.edges = new ArrayList<ChainEdge>();
        }
        this.edges.add(edge);
        boolean findSource = false;
        boolean findTarget = false;
        for (ChainNode node : this.nodes) {
            if (node.getId().equals(edge.getSource())) {
                node.addOutwardEdge(edge);
                findSource = true;
            } else if (node.getId().equals(edge.getTarget())) {
                node.addInwardEdge(edge);
                findTarget = true;
            }
            if (!findSource || !findTarget) continue;
            break;
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ExecutorService getAsyncNodeExecutors() {
        return this.asyncNodeExecutors;
    }

    public void setAsyncNodeExecutors(ExecutorService asyncNodeExecutors) {
        this.asyncNodeExecutors = asyncNodeExecutors;
    }

    public String toString() {
        return "Chain{id='" + this.id + '\'' + ", memory=" + this.memory + ", eventListeners=" + this.eventListeners + ", outputListeners=" + this.outputListeners + ", nodes=" + this.nodes + ", lines=" + this.edges + ", status=" + (Object)((Object)this.status) + ", message='" + this.message + '\'' + '}';
    }

    public static class ExecuteNode {
        final ChainNode currentNode;
        final ChainNode prevNode;
        final String fromEdgeId;

        public ExecuteNode(ChainNode currentNode, ChainNode prevNode, String fromEdgeId) {
            this.currentNode = currentNode;
            this.prevNode = prevNode;
            this.fromEdgeId = fromEdgeId;
        }
    }
}

