/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.InputParameter;
import com.agentsflex.core.chain.OutputKey;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseNode
extends ChainNode {
    protected String description;
    protected List<InputParameter> inputParameters;
    protected List<OutputKey> outputKeys;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<InputParameter> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(List<InputParameter> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public void addInputParameter(InputParameter inputParameter) {
        if (this.inputParameters == null) {
            this.inputParameters = new ArrayList<InputParameter>();
        }
        this.inputParameters.add(inputParameter);
    }

    public List<OutputKey> getOutputKeys() {
        return this.outputKeys;
    }

    public void setOutputKeys(List<OutputKey> outputKeys) {
        this.outputKeys = outputKeys;
    }

    public void addOutputKey(OutputKey outputKey) {
        if (this.outputKeys == null) {
            this.outputKeys = new ArrayList<OutputKey>();
        }
        this.outputKeys.add(outputKey);
    }

    public Map<String, Object> getChainParameters(Chain chain, List<InputParameter> inputParameters) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (inputParameters != null) {
            for (InputParameter parameter : inputParameters) {
                RefType refType = parameter.getRefType();
                Object value = refType == RefType.INPUT ? parameter.getRef() : (refType == RefType.REF ? chain.get(parameter.getRef()) : chain.get(parameter.getName()));
                if (parameter.isRequired() && (value == null || value instanceof String && StringUtil.noText((String)value))) {
                    chain.stopError(this.getName() + " Missing required parameter:" + parameter.getName());
                }
                if (value == null || value instanceof String) {
                    Object object = value = value == null ? "" : ((String)value).trim();
                    if (parameter.getDataType() == DataType.Boolean) {
                        value = "true".equalsIgnoreCase((String)value) || "1".equalsIgnoreCase((String)value);
                    } else if (parameter.getDataType() == DataType.Number) {
                        value = Long.parseLong((String)value);
                    }
                }
                variables.put(parameter.getName(), value);
            }
        }
        return variables;
    }

    public Map<String, Object> getParameters(Chain chain) {
        return this.getChainParameters(chain, this.inputParameters);
    }
}

