/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.functions;

import com.agentsflex.core.functions.Function;
import com.agentsflex.core.functions.JavaNativeFunction;
import com.agentsflex.core.functions.annotation.FunctionDef;
import com.agentsflex.core.util.ArrayUtil;
import com.agentsflex.core.util.ClassUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class JavaNativeFunctions
extends ArrayList<Function> {
    public static JavaNativeFunctions from(Object object, String ... methodNames) {
        return JavaNativeFunctions.from(object.getClass(), object, methodNames);
    }

    public static JavaNativeFunctions from(Class<?> clazz, String ... methodNames) {
        return JavaNativeFunctions.from(clazz, null, methodNames);
    }

    private static JavaNativeFunctions from(Class<?> clazz, Object object, String ... methodNames) {
        clazz = ClassUtil.getUsefulClass(clazz);
        List<Method> methodList = ClassUtil.getAllMethods(clazz, method -> {
            if (object == null && !Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (method.getAnnotation(FunctionDef.class) == null) {
                return false;
            }
            if (methodNames.length > 0) {
                return ArrayUtil.contains(methodNames, method.getName());
            }
            return true;
        });
        JavaNativeFunctions javaNativeFunctions = new JavaNativeFunctions();
        for (Method method2 : methodList) {
            JavaNativeFunction function = new JavaNativeFunction();
            function.setClazz(clazz);
            function.setMethod(method2);
            if (!Modifier.isStatic(method2.getModifiers())) {
                function.setObject(object);
            }
            javaNativeFunctions.add(function);
        }
        return javaNativeFunctions;
    }
}

