/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.image;

import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.util.IOUtil;
import com.agentsflex.core.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Base64;

public class Image {
    private String b64Json;
    private String url;
    private byte[] bytes;

    public static Image ofUrl(String url) {
        Image image = new Image();
        image.setUrl(url);
        return image;
    }

    public static Image ofBytes(byte[] bytes) {
        Image image = new Image();
        image.setBytes(bytes);
        return image;
    }

    public String getB64Json() {
        return this.b64Json;
    }

    public void setB64Json(String b64Json) {
        this.b64Json = b64Json;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] readBytes() {
        return this.bytes;
    }

    public void writeToFile(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalStateException("Can not mkdirs for path: " + file.getParentFile().getAbsolutePath());
        }
        if (this.bytes != null && this.bytes.length > 0) {
            IOUtil.writeBytes(this.bytes, file);
        } else if (this.b64Json != null) {
            byte[] bytes = Base64.getDecoder().decode(this.b64Json);
            IOUtil.writeBytes(bytes, file);
        } else if (StringUtil.hasText(this.url)) {
            byte[] bytes = new HttpClient().getBytes(this.url);
            IOUtil.writeBytes(bytes, file);
        }
    }

    public String toString() {
        return "Image{b64Json='" + this.b64Json + '\'' + ", url='" + this.url + '\'' + ", bytes=" + Arrays.toString(this.bytes) + '}';
    }
}

