/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm;

import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.embedding.EmbeddingModel;
import com.agentsflex.core.llm.exception.LlmException;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AbstractTextMessage;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.TextPrompt;

public interface Llm
extends EmbeddingModel {
    default public String chat(String prompt) {
        return this.chat(prompt, ChatOptions.DEFAULT);
    }

    default public String chat(String prompt, ChatOptions options) {
        AiMessageResponse response = this.chat(new TextPrompt(prompt), options);
        if (response != null && response.isError()) {
            throw new LlmException(response.getErrorMessage());
        }
        return response != null && response.getMessage() != null ? ((AbstractTextMessage)response.getMessage()).getContent() : null;
    }

    default public AiMessageResponse chat(Prompt prompt) {
        return this.chat(prompt, ChatOptions.DEFAULT);
    }

    public AiMessageResponse chat(Prompt var1, ChatOptions var2);

    default public void chatStream(String prompt, StreamResponseListener listener) {
        this.chatStream(new TextPrompt(prompt), listener, ChatOptions.DEFAULT);
    }

    default public void chatStream(String prompt, StreamResponseListener listener, ChatOptions options) {
        this.chatStream(new TextPrompt(prompt), listener, options);
    }

    default public void chatStream(Prompt prompt, StreamResponseListener listener) {
        this.chatStream(prompt, listener, ChatOptions.DEFAULT);
    }

    public void chatStream(Prompt var1, StreamResponseListener var2, ChatOptions var3);
}

