/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.client.impl;

import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.OkHttpClientUtil;
import com.agentsflex.core.llm.client.impl.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class DnjsonClient
implements LlmClient,
Callback {
    private static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private OkHttpClient okHttpClient;
    private LlmClientListener listener;
    private LlmConfig config;
    private boolean isStop = false;

    @Override
    public void start(String url, Map<String, String> headers, String payload, LlmClientListener listener, LlmConfig config) {
        this.listener = listener;
        this.config = config;
        this.isStop = false;
        Request.Builder rBuilder = new Request.Builder().url(url);
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)rBuilder).addHeader(arg_0, arg_1));
        }
        RequestBody body = RequestBody.create((String)payload, (MediaType)JSON_TYPE);
        rBuilder.post(body);
        this.okHttpClient = OkHttpClientUtil.buildDefaultClient();
        if (this.config.isDebug()) {
            System.out.println(">>>>send payload:" + payload);
        }
        this.listener.onStart(this);
        this.okHttpClient.newCall(rBuilder.build()).enqueue((Callback)this);
    }

    @Override
    public void stop() {
        this.tryToStop();
    }

    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        try {
            this.listener.onFailure(this, Util.getFailureThrowable(e, null));
        }
        finally {
            this.tryToStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        if (!response.isSuccessful()) {
            this.tryToStop();
            return;
        }
        ResponseBody body = response.body();
        if (body == null) {
            this.tryToStop();
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(body.byteStream()));){
            String s = reader.readLine();
            while (s != null) {
                try {
                    this.listener.onMessage(this, s);
                }
                finally {
                    s = reader.readLine();
                }
            }
        }
        finally {
            this.tryToStop();
        }
    }

    private boolean tryToStop() {
        if (!this.isStop) {
            try {
                this.isStop = true;
                this.listener.onStop(this);
            }
            finally {
                if (this.okHttpClient != null) {
                    this.okHttpClient.dispatcher().executorService().shutdown();
                }
            }
            return true;
        }
        return false;
    }
}

