/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.memory;

import com.agentsflex.core.memory.ContextMemory;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultContextMemory
implements ContextMemory {
    protected Map<String, Object> context = new ConcurrentHashMap<String, Object>();

    @Override
    public Object id() {
        return UUID.randomUUID().toString();
    }

    @Override
    public Object get(String key) {
        return this.context.get(key);
    }

    @Override
    public Map<String, Object> getAll() {
        return this.context;
    }

    @Override
    public void put(String key, Object value) {
        if (value == null) {
            this.context.remove(key);
        } else {
            this.context.put(key, value);
        }
    }

    @Override
    public void putAll(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        map.forEach((string, object) -> {
            if (object == null) {
                this.context.remove(string);
            } else {
                this.context.put((String)string, object);
            }
        });
    }

    @Override
    public void remove(String key) {
        this.context.remove(key);
    }

    @Override
    public void clear() {
        this.context.clear();
    }
}

