/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.parser.impl;

import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.FunctionCall;
import com.agentsflex.core.message.MessageStatus;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.JSONObjectParser;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultAiMessageParser
implements AiMessageParser {
    private String contentPath;
    private String indexPath;
    private String totalTokensPath;
    private String promptTokensPath;
    private String completionTokensPath;
    private JSONObjectParser<MessageStatus> statusParser;
    private JSONObjectParser<List<FunctionCall>> callsParser;

    public String getContentPath() {
        return this.contentPath;
    }

    public void setContentPath(String contentPath) {
        this.contentPath = contentPath;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public String getTotalTokensPath() {
        return this.totalTokensPath;
    }

    public void setTotalTokensPath(String totalTokensPath) {
        this.totalTokensPath = totalTokensPath;
    }

    public String getPromptTokensPath() {
        return this.promptTokensPath;
    }

    public void setPromptTokensPath(String promptTokensPath) {
        this.promptTokensPath = promptTokensPath;
    }

    public String getCompletionTokensPath() {
        return this.completionTokensPath;
    }

    public void setCompletionTokensPath(String completionTokensPath) {
        this.completionTokensPath = completionTokensPath;
    }

    public JSONObjectParser<MessageStatus> getStatusParser() {
        return this.statusParser;
    }

    public void setStatusParser(JSONObjectParser<MessageStatus> statusParser) {
        this.statusParser = statusParser;
    }

    public JSONObjectParser<List<FunctionCall>> getCallsParser() {
        return this.callsParser;
    }

    public void setCallsParser(JSONObjectParser<List<FunctionCall>> callsParser) {
        this.callsParser = callsParser;
    }

    @Override
    public AiMessage parse(JSONObject rootJson) {
        AiMessage aiMessage = new AiMessage();
        if (StringUtil.hasText(this.contentPath)) {
            aiMessage.setContent((String)JSONPath.eval((Object)rootJson, (String)this.contentPath));
        }
        if (StringUtil.hasText(this.indexPath)) {
            aiMessage.setIndex((Integer)JSONPath.eval((Object)rootJson, (String)this.indexPath));
        }
        if (StringUtil.hasText(this.promptTokensPath)) {
            aiMessage.setPromptTokens((Integer)JSONPath.eval((Object)rootJson, (String)this.promptTokensPath));
        }
        if (StringUtil.hasText(this.completionTokensPath)) {
            aiMessage.setCompletionTokens((Integer)JSONPath.eval((Object)rootJson, (String)this.completionTokensPath));
        }
        if (StringUtil.hasText(this.totalTokensPath)) {
            aiMessage.setTotalTokens((Integer)JSONPath.eval((Object)rootJson, (String)this.totalTokensPath));
        } else if (aiMessage.getPromptTokens() != null && aiMessage.getCompletionTokens() != null) {
            aiMessage.setTotalTokens(aiMessage.getPromptTokens() + aiMessage.getCompletionTokens());
        }
        if (this.statusParser != null) {
            aiMessage.setStatus((MessageStatus)this.statusParser.parse(rootJson));
        }
        if (this.callsParser != null) {
            aiMessage.setCalls((List)this.callsParser.parse(rootJson));
        }
        return aiMessage;
    }

    public static DefaultAiMessageParser getChatGPTMessageParser(boolean isStream) {
        DefaultAiMessageParser aiMessageParser = new DefaultAiMessageParser();
        if (isStream) {
            aiMessageParser.setContentPath("$.choices[0].delta.content");
        } else {
            aiMessageParser.setContentPath("$.choices[0].message.content");
        }
        aiMessageParser.setIndexPath("$.choices[0].index");
        aiMessageParser.setTotalTokensPath("$.usage.total_tokens");
        aiMessageParser.setPromptTokensPath("$.usage.prompt_tokens");
        aiMessageParser.setCompletionTokensPath("$.usage.completion_tokens");
        aiMessageParser.setStatusParser(content -> {
            Object finishReason = JSONPath.eval((Object)content, (String)"$.choices[0].finish_reason");
            if (finishReason != null) {
                return MessageStatus.END;
            }
            return MessageStatus.MIDDLE;
        });
        aiMessageParser.setCallsParser(content -> {
            JSONArray toolCalls = (JSONArray)JSONPath.eval((Object)content, (String)"$.choices[0].message.tool_calls");
            if (toolCalls == null || toolCalls.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<FunctionCall> functionCalls = new ArrayList<FunctionCall>();
            for (int i = 0; i < toolCalls.size(); ++i) {
                JSONObject jsonObject = toolCalls.getJSONObject(i);
                JSONObject functionObject = jsonObject.getJSONObject("function");
                if (functionObject == null) continue;
                FunctionCall functionCall = new FunctionCall();
                functionCall.setName(functionObject.getString("name"));
                Object arguments = functionObject.get((Object)"arguments");
                if (arguments instanceof Map) {
                    functionCall.setArgs((Map)arguments);
                } else if (arguments instanceof String) {
                    functionCall.setArgs((Map)JSON.parseObject((String)arguments.toString(), Map.class));
                }
                functionCalls.add(functionCall);
            }
            return functionCalls;
        });
        return aiMessageParser;
    }
}

