/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt.template;

import com.agentsflex.core.prompt.TextPrompt;
import com.agentsflex.core.prompt.template.PromptTemplate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TextPromptTemplate
implements PromptTemplate<TextPrompt> {
    private final Set<String> keys = new HashSet<String>();
    private final List<String> parts = new ArrayList<String>(){

        @Override
        public boolean add(String string) {
            if (string.charAt(0) == '{' && string.length() > 2 && string.charAt(string.length() - 1) == '}') {
                TextPromptTemplate.this.keys.add(string.substring(1, string.length() - 1));
            }
            return super.add(string);
        }
    };

    public TextPromptTemplate(String template) {
        boolean isCurrentInKeyword = false;
        StringBuilder keyword = null;
        StringBuilder content = null;
        for (int index = 0; index < template.length(); ++index) {
            char c = template.charAt(index);
            if (c == '{' && !isCurrentInKeyword) {
                isCurrentInKeyword = true;
                keyword = new StringBuilder("{");
                if (content == null) continue;
                this.parts.add(content.toString());
                content = null;
                continue;
            }
            if (c == '}' && isCurrentInKeyword) {
                isCurrentInKeyword = false;
                keyword.append("}");
                this.parts.add(keyword.toString());
                keyword = null;
                continue;
            }
            if (isCurrentInKeyword) {
                if (Character.isWhitespace(c)) continue;
                keyword.append(c);
                continue;
            }
            if (content == null) {
                content = new StringBuilder();
            }
            content.append(c);
        }
        if (keyword != null) {
            this.parts.add(keyword.toString());
        }
        if (content != null) {
            this.parts.add(content.toString());
        }
    }

    public static TextPromptTemplate create(String template) {
        return new TextPromptTemplate(template);
    }

    @Override
    public TextPrompt format(Map<String, Object> params) {
        return new TextPrompt(this.formatToString(params));
    }

    public String formatToString(Map<String, Object> params) {
        StringBuilder result = new StringBuilder();
        for (String part : this.parts) {
            if (part.charAt(0) == '{' && part.charAt(part.length() - 1) == '}') {
                if (part.length() <= 2) continue;
                String key = part.substring(1, part.length() - 1);
                Object value = this.getParams(key, params);
                result.append(value == null ? "" : value);
                continue;
            }
            result.append(part);
        }
        return result.toString();
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public List<String> getParts() {
        return this.parts;
    }

    private Object getParams(String keysString, Map<String, Object> params) {
        return params != null ? params.get(keysString) : null;
    }

    public String toString() {
        return "SimplePromptTemplate{keys=" + this.keys + ", parts=" + this.parts + '}';
    }
}

