/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.image.openai;

import com.agentsflex.core.image.EditImageRequest;
import com.agentsflex.core.image.GenerateImageRequest;
import com.agentsflex.core.image.ImageModel;
import com.agentsflex.core.image.ImageResponse;
import com.agentsflex.core.image.VaryImageRequest;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.image.openai.OpenAiImageModelConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;

public class OpenAiImageModel
implements ImageModel {
    private OpenAiImageModelConfig config;
    private HttpClient httpClient = new HttpClient();

    public OpenAiImageModel(OpenAiImageModelConfig config) {
        this.config = config;
    }

    public ImageResponse generate(GenerateImageRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + this.config.getApiKey());
        String payload = Maps.of((String)"model", (Object)this.config.getModel()).set("prompt", (Object)request.getPrompt()).setIfNotNull("n", (Object)request.getN()).set("size", (Object)request.getSize()).toJSON();
        String url = this.config.getEndpoint() + "/v1/images/generations";
        String responseJson = this.httpClient.post(url, headers, payload);
        if (StringUtil.noText((String)responseJson)) {
            return ImageResponse.error((String)"response is no text");
        }
        JSONObject root = JSON.parseObject((String)responseJson);
        JSONArray images = root.getJSONArray("data");
        if (images == null || images.isEmpty()) {
            return ImageResponse.error((String)("image data is empty: " + responseJson));
        }
        ImageResponse response = new ImageResponse();
        for (int i = 0; i < images.size(); ++i) {
            JSONObject imageObj = images.getJSONObject(i);
            response.addImage(imageObj.getString("url"));
        }
        return response;
    }

    public ImageResponse edit(EditImageRequest request) {
        throw new UnsupportedOperationException("not support edit image");
    }

    public ImageResponse vary(VaryImageRequest request) {
        throw new UnsupportedOperationException("not support vary image");
    }
}

