/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.image.stability;

import com.agentsflex.core.image.EditImageRequest;
import com.agentsflex.core.image.GenerateImageRequest;
import com.agentsflex.core.image.ImageModel;
import com.agentsflex.core.image.ImageResponse;
import com.agentsflex.core.image.VaryImageRequest;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.util.Maps;
import com.agentsflex.image.stability.StabilityImageModelConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StabilityImageModel
implements ImageModel {
    private static final Logger LOG = LoggerFactory.getLogger(StabilityImageModel.class);
    private StabilityImageModelConfig config;
    private HttpClient httpClient = new HttpClient();

    public StabilityImageModel(StabilityImageModelConfig config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageResponse generate(GenerateImageRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", "image/*");
        headers.put("Authorization", "Bearer " + this.config.getApiKey());
        Maps payload = Maps.of((String)"prompt", (Object)request.getPrompt()).setIfNotNull("output_format", (Object)"jpeg");
        String url = this.config.getEndpoint() + "/v2beta/stable-image/generate/sd3";
        try (Response response = this.httpClient.multipart(url, headers, (Map)payload);
             ResponseBody body = response.body();){
            if (!response.isSuccessful()) return null;
            if (body == null) return null;
            ImageResponse imageResponse = new ImageResponse();
            imageResponse.addImage(body.bytes());
            ImageResponse imageResponse2 = imageResponse;
            return imageResponse2;
        }
        catch (IOException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        return null;
    }

    public ImageResponse edit(EditImageRequest request) {
        return null;
    }

    public ImageResponse vary(VaryImageRequest request) {
        return null;
    }
}

