/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.spring.boot.llm.openai;

import com.agentsflex.llm.openai.OpenAILlm;
import com.agentsflex.llm.openai.OpenAILlmConfig;
import com.agentsflex.spring.boot.llm.openai.OpenAiProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={OpenAILlm.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OpenAiProperties.class})
public class OpenAiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OpenAILlm openAiLlm(OpenAiProperties properties) {
        OpenAILlmConfig config = new OpenAILlmConfig();
        config.setApiKey(properties.getApiKey());
        config.setApiSecret(properties.getApiSecret());
        config.setEndpoint(properties.getEndpoint());
        config.setModel(properties.getModel());
        return new OpenAILlm(config);
    }
}

