/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.gru.http;

import com.agorapulse.gru.Client;
import com.agorapulse.gru.MultipartDefinition;
import com.agorapulse.gru.TestDefinitionBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;

class GruHttpRequest
implements Client.Request {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private final Request.Builder builder = new Request.Builder();
    private RequestBody body;
    private String baseUri;
    private String method = "GET";
    private String uri;

    GruHttpRequest() {
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getUri() {
        return null;
    }

    public String getMethod() {
        return null;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void addHeader(String name, String value) {
        this.builder.addHeader(name, value);
    }

    public void setJson(String jsonText) {
        this.body = RequestBody.create((MediaType)JSON, (String)jsonText);
    }

    public void setContent(String contentType, byte[] payload) {
        this.body = RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])payload);
    }

    public void setMultipart(MultipartDefinition definition) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        definition.getFiles().forEach((k, f) -> builder.addFormDataPart(f.getParameterName(), f.getFilename(), RequestBody.create((MediaType)MediaType.parse((String)f.getContentType()), (byte[])f.getBytes())));
        definition.getParameters().forEach((k, v) -> builder.addFormDataPart(k, v == null ? "" : String.valueOf(v)));
        this.body = builder.build();
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value == null ? "" : value.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    Request buildOkHttpRequest() {
        HttpUrl.Builder url;
        if (this.baseUri != null) {
            String pathSegment = this.uri != null && this.uri.startsWith("/") ? this.uri.substring(1) : this.uri;
            url = Objects.requireNonNull(HttpUrl.parse((String)this.baseUri)).newBuilder().addPathSegments(pathSegment);
        } else {
            url = Objects.requireNonNull(HttpUrl.parse((String)this.uri)).newBuilder();
        }
        if (!this.parameters.isEmpty()) {
            if (!TestDefinitionBuilder.HAS_URI_PARAMETERS.contains(this.method) && this.body == null) {
                FormBody.Builder form = new FormBody.Builder();
                this.parameters.forEach((arg_0, arg_1) -> ((FormBody.Builder)form).add(arg_0, arg_1));
                this.builder.method(this.method, (RequestBody)form.build());
                return this.builder.url(url.toString()).build();
            }
            this.parameters.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)url).addQueryParameter(arg_0, arg_1));
            this.builder.method(this.method, this.body);
            return this.builder.url(url.toString()).build();
        }
        if (!HttpMethod.requiresRequestBody((String)this.method)) {
            this.builder.method(this.method, this.body);
            return this.builder.url(url.toString()).build();
        }
        this.builder.method(this.method, this.body != null ? this.body : RequestBody.create(null, (String)""));
        return this.builder.url(url.toString()).build();
    }
}

