/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.gru.http;

import com.agorapulse.gru.Client;
import java.io.IOException;
import java.util.List;
import okhttp3.Response;
import okhttp3.ResponseBody;

class GruHttpResponse
implements Client.Response {
    private final Response response;

    public GruHttpResponse(Response response) {
        this.response = response;
    }

    public int getStatus() {
        Response priorResponse = this.response.priorResponse();
        if (priorResponse != null && priorResponse.isRedirect()) {
            return priorResponse.code();
        }
        return this.response.code();
    }

    public List<String> getHeaders(String name) {
        return this.response.headers(name);
    }

    public String getText() {
        try {
            ResponseBody body = this.response.body();
            return body == null ? null : body.string();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read response body", e);
        }
    }

    public String getRedirectUrl() {
        Response priorResponse = this.response.priorResponse();
        return priorResponse == null ? null : priorResponse.header("Location");
    }
}

