/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.gru.http;

import com.agorapulse.gru.AbstractClient;
import com.agorapulse.gru.Client;
import com.agorapulse.gru.GruContext;
import com.agorapulse.gru.Squad;
import com.agorapulse.gru.http.GruHttpRequest;
import com.agorapulse.gru.http.GruHttpResponse;
import java.io.IOException;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class Http
extends AbstractClient {
    private final OkHttpClient httpClient;
    private GruHttpRequest request = new GruHttpRequest();
    private GruHttpResponse response;

    public static Http create(Object unitTest) {
        return new Http(unitTest, null);
    }

    public static Http create(Class<?> unitTestClass) {
        return new Http(unitTestClass, null);
    }

    public static Http create(Object unitTest, Consumer<OkHttpClient.Builder> configuration) {
        return new Http(unitTest, configuration);
    }

    public static Http create(Class<?> unitTestClass, Consumer<OkHttpClient.Builder> configuration) {
        return new Http(unitTestClass, configuration);
    }

    @Deprecated
    public static Http steal(Object unitTest) {
        return Http.create(unitTest);
    }

    @Deprecated
    public static Http steal(Object unitTest, Consumer<OkHttpClient.Builder> configuration) {
        return Http.create(unitTest, configuration);
    }

    private Http(Object unitTest, Consumer<OkHttpClient.Builder> configuration) {
        super(unitTest);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (configuration != null) {
            configuration.accept(builder);
        }
        this.httpClient = builder.build();
    }

    private Http(Class<?> unitTestClass, Consumer<OkHttpClient.Builder> configuration) {
        super(unitTestClass);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (configuration != null) {
            configuration.accept(builder);
        }
        this.httpClient = builder.build();
    }

    public Client.Request getRequest() {
        return this.request;
    }

    public Client.Response getResponse() {
        if (this.response == null) {
            throw new IllegalStateException("Response hasn't been set yet");
        }
        return this.response;
    }

    public void reset() {
        this.request = new GruHttpRequest();
        this.response = null;
    }

    public GruContext run(Squad squad, GruContext context) {
        try {
            Response response = this.httpClient.newCall(this.request.buildOkHttpRequest()).execute();
            this.response = new GruHttpResponse(response);
            return context.withResult((Object)response);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to execute request " + this.request, e);
        }
    }
}

