/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.sns;

import com.agorapulse.micronaut.amazon.awssdk.sns.SimpleNotificationService;
import com.agorapulse.micronaut.amazon.awssdk.sns.SimpleNotificationServiceConfiguration;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest;
import software.amazon.awssdk.services.sns.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.InvalidParameterException;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.NotFoundException;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.Topic;

public class DefaultSimpleNotificationService
implements SimpleNotificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSimpleNotificationService.class);
    private final Map<String, String> namesToArn = new ConcurrentHashMap<String, String>();
    private final SnsClient client;
    private final SimpleNotificationServiceConfiguration configuration;
    private final ObjectMapper objectMapper;

    public DefaultSimpleNotificationService(SnsClient client, SimpleNotificationServiceConfiguration configuration, ObjectMapper objectMapper) {
        this.client = client;
        this.configuration = configuration;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getPlatformApplicationArn(SimpleNotificationService.PlatformType platformType) {
        switch (platformType) {
            case ADM: {
                return DefaultSimpleNotificationService.checkNotEmpty(this.configuration.getAdm().getArn(), "Amazon Device Manager application arn must be defined in config");
            }
            case APNS: {
                return DefaultSimpleNotificationService.checkNotEmpty(this.configuration.getApns().getArn(), "Apple Push Notification service application arn must be defined in config");
            }
            case APNS_SANDBOX: {
                return DefaultSimpleNotificationService.checkNotEmpty(this.configuration.getApnsSandbox().getArn(), "Apple Push Notification service Sandbox application arn must be defined in config");
            }
            case GCM: {
                return DefaultSimpleNotificationService.checkNotEmpty(this.configuration.getGcm().getArn(), "Google Cloud Messaging (Firebase) application arn must be defined in config");
            }
        }
        throw new IllegalArgumentException("Unknown platform type " + (Object)((Object)platformType));
    }

    @Override
    @Deprecated
    public String getAmazonApplicationArn() {
        return DefaultSimpleNotificationService.checkNotEmpty(this.configuration.getAmazon().getArn(), "Amazon application arn must be defined in config");
    }

    @Override
    @Deprecated
    public String getAndroidApplicationArn() {
        return DefaultSimpleNotificationService.checkNotEmpty(this.configuration.getAmazon().getArn(), "Android application arn must be defined in config");
    }

    @Override
    @Deprecated
    public String getIosApplicationArn() {
        return DefaultSimpleNotificationService.checkNotEmpty(this.configuration.getIos().getArn(), "Ios application arn must be defined in config");
    }

    @Override
    @Deprecated
    public String getIosSandboxApplicationArn() {
        return DefaultSimpleNotificationService.checkNotEmpty(this.configuration.getIosSandbox().getArn(), "Ios sandbox application arn must be defined in config");
    }

    @Override
    public String getDefaultTopicNameOrArn() {
        return DefaultSimpleNotificationService.checkNotEmpty(this.ensureTopicArn(this.configuration.getTopic()), "Default topic not set for the configuration");
    }

    @Override
    public String createTopic(String topicName) {
        LOGGER.debug("Creating topic sns with name " + topicName);
        return this.client.createTopic(b -> b.name(topicName).attributes(Collections.singletonMap("FifoTopic", Boolean.toString(SimpleNotificationService.isFifoTopic(topicName))))).topicArn();
    }

    @Override
    public Publisher<Topic> listTopics() {
        return Flux.generate(() -> ((SnsClient)this.client).listTopics(), (listTopicsResult, sink) -> {
            sink.next((Object)listTopicsResult.topics());
            if (listTopicsResult.nextToken() != null) {
                try {
                    return this.client.listTopics(r -> r.nextToken(listTopicsResult.nextToken()));
                }
                catch (SdkClientException e) {
                    sink.error((Throwable)e);
                }
            }
            sink.complete();
            return (ListTopicsResponse)ListTopicsResponse.builder().build();
        }).flatMap(Flux::fromIterable);
    }

    @Override
    public void deleteTopic(String topicArn) {
        LOGGER.debug("Deleting topic" + topicArn);
        this.client.deleteTopic(b -> b.topicArn(this.ensureTopicArn(topicArn)));
    }

    @Override
    public String subscribeTopic(String topic, String protocol, String endpoint) {
        LOGGER.debug("Creating a topic subscription to endpoint " + endpoint);
        return this.client.subscribe(b -> b.topicArn(this.ensureTopicArn(topic)).protocol(protocol).endpoint(endpoint)).subscriptionArn();
    }

    @Override
    public void unsubscribeTopic(String arn) {
        LOGGER.debug("Deleting a topic subscription to number " + arn);
        this.client.unsubscribe(b -> b.subscriptionArn(arn));
    }

    @Override
    public String publishMessageToTopic(String topicArn, String subject, String message, Map<String, String> attributes) {
        return this.client.publish(r -> r.topicArn(this.ensureTopicArn(topicArn)).message(message).subject(subject).messageAttributes(DefaultSimpleNotificationService.toAttributes(attributes))).messageId();
    }

    @Override
    public String publishRequest(String topicArn, Map<String, String> attributes, PublishRequest.Builder publishRequestBuilder) {
        return this.client.publish((PublishRequest)publishRequestBuilder.topicArn(this.ensureTopicArn(topicArn)).messageAttributes(DefaultSimpleNotificationService.toAttributes(attributes)).build()).messageId();
    }

    @Override
    public String createPlatformApplication(String name, SimpleNotificationService.PlatformType platformType, String principal, String credential) {
        return this.createPlatformApplication(name, platformType.toString(), principal, credential);
    }

    @Override
    @Deprecated
    public String createPlatformApplication(String name, String endpointName, String principal, String credential) {
        return this.client.createPlatformApplication(r -> {
            r.name(name).platform(endpointName);
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (principal != null && !principal.isEmpty()) {
                attributes.put("PlatformPrincipal", principal);
            }
            if (credential != null && !credential.isEmpty()) {
                attributes.put("PlatformCredential", credential);
            }
            if (!attributes.isEmpty()) {
                r.attributes(attributes);
            }
        }).platformApplicationArn();
    }

    @Override
    public String createPlatformEndpoint(String platformApplicationArn, String deviceToken, String customUserData) {
        try {
            LOGGER.debug("Creating platform endpoint with token " + deviceToken);
            CreatePlatformEndpointRequest.Builder request = CreatePlatformEndpointRequest.builder().platformApplicationArn(platformApplicationArn).token(deviceToken);
            if (customUserData != null && !customUserData.isEmpty()) {
                request.customUserData(customUserData);
            }
            return this.client.createPlatformEndpoint((CreatePlatformEndpointRequest)request.build()).endpointArn();
        }
        catch (InvalidParameterException ipe) {
            String message = ipe.getMessage();
            LOGGER.debug("Exception message: " + message);
            Pattern p = Pattern.compile(".*Endpoint (arn:aws:sns[^ ]+) already exists with the same Token.*");
            Matcher m = p.matcher(message);
            if (m.matches()) {
                return m.group(1);
            }
            throw ipe;
        }
    }

    @Override
    @Deprecated
    public String sendAndroidAppNotification(String endpointArn, Map<String, Object> notification, String collapseKey, boolean delayWhileIdle, int timeToLive, boolean dryRun) {
        return this.publishToTarget(endpointArn, SimpleNotificationService.PlatformType.GCM.toString(), this.buildAndroidMessage(notification, collapseKey, delayWhileIdle, timeToLive, dryRun));
    }

    @Override
    @Deprecated
    public String sendIosAppNotification(String endpointArn, Map<String, Object> notification, boolean sandbox) {
        return this.publishToTarget(endpointArn, sandbox ? SimpleNotificationService.PlatformType.APNS_SANDBOX.toString() : SimpleNotificationService.PlatformType.APNS.toString(), this.buildIosMessage(notification));
    }

    @Override
    public String sendNotification(String endpointArn, SimpleNotificationService.PlatformType platformType, String jsonMessage) {
        return this.publishToTarget(endpointArn, platformType.toString(), jsonMessage);
    }

    @Override
    public String validateDeviceToken(String platformApplicationArn, String endpointArn, String deviceToken, String customUserData) {
        LOGGER.debug("Retrieving platform endpoint data...");
        try {
            GetEndpointAttributesResponse result = this.client.getEndpointAttributes(r -> r.endpointArn(endpointArn));
            if (Objects.equals(result.attributes().get("Token"), deviceToken) && ((String)result.attributes().get("Enabled")).equalsIgnoreCase(Boolean.TRUE.toString())) {
                this.setEndpointAttributes(endpointArn, Collections.singletonMap("CustomUserData", customUserData));
                return endpointArn;
            }
        }
        catch (NotFoundException ignored) {
            return this.createPlatformEndpoint(platformApplicationArn, deviceToken, customUserData);
        }
        LOGGER.debug("Platform endpoint update required...");
        LOGGER.debug("Updating platform endpoint " + endpointArn);
        try {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            attrs.put("CustomUserData", customUserData);
            attrs.put("Enabled", Boolean.TRUE.toString());
            this.setEndpointAttributes(endpointArn, attrs);
            return endpointArn;
        }
        catch (InvalidParameterException ignored) {
            this.deleteEndpoint(endpointArn);
            return this.createPlatformEndpoint(platformApplicationArn, deviceToken, customUserData);
        }
    }

    @Override
    public void unregisterDevice(String endpointArn) {
        this.deleteEndpoint(endpointArn);
    }

    @Override
    public String sendSMSMessage(String phoneNumber, String message, Map<String, MessageAttributeValue> smsAttributes) {
        return this.client.publish(r -> r.message(message).phoneNumber(phoneNumber).messageAttributes(smsAttributes)).messageId();
    }

    private static String checkNotEmpty(String arn, String errorMessage) {
        if (arn == null || arn.isEmpty()) {
            throw new IllegalStateException(errorMessage);
        }
        return arn;
    }

    private static Map<String, MessageAttributeValue> toAttributes(Map<String, String> attributes) {
        if (attributes.isEmpty()) {
            return Collections.emptyMap();
        }
        return attributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (MessageAttributeValue)MessageAttributeValue.builder().stringValue((String)e.getValue()).dataType("String").build()));
    }

    private String ensureTopicArn(String nameOrArn) {
        if (nameOrArn == null || nameOrArn.isEmpty()) {
            return "";
        }
        if (nameOrArn.startsWith("arn:aws:sns")) {
            return nameOrArn;
        }
        if (this.namesToArn.containsKey(nameOrArn)) {
            return this.namesToArn.get(nameOrArn);
        }
        Flux.from(this.listTopics()).takeUntil(topic -> topic.topicArn().endsWith(":" + nameOrArn)).subscribe(topic -> {
            String topicName = topic.topicArn().substring(topic.topicArn().lastIndexOf(58) + 1);
            this.namesToArn.put(topicName, topic.topicArn());
        });
        String topicArn = this.namesToArn.get(nameOrArn);
        if (topicArn != null && !topicArn.isEmpty()) {
            return topicArn;
        }
        return this.createTopic(nameOrArn);
    }

    private String buildAndroidMessage(Map<String, Object> data, String collapseKey, boolean delayWhileIdle, int timeToLive, boolean dryRun) {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        value.put("collapse_key", collapseKey);
        value.put("data", data);
        value.put("delay_while_idle", delayWhileIdle);
        value.put("time_to_live", timeToLive);
        value.put("dry_run", dryRun);
        return this.toJson(value);
    }

    private String buildIosMessage(Map<String, Object> data) {
        return this.toJson(Collections.singletonMap("aps", data));
    }

    private String publishToTarget(String endpointArn, String platformType, String jsonMessage) {
        return this.client.publish(r -> r.targetArn(endpointArn).messageStructure("json").message(this.toJson(Collections.singletonMap(platformType, jsonMessage)))).messageId();
    }

    private SetEndpointAttributesResponse setEndpointAttributes(String endpointArn, Map<String, String> attributes) {
        return this.client.setEndpointAttributes(r -> r.endpointArn(endpointArn).attributes(attributes));
    }

    private DeleteEndpointResponse deleteEndpoint(String endpointArn) {
        return this.client.deleteEndpoint(r -> r.endpointArn(endpointArn));
    }

    private String toJson(Map<String, Object> message) {
        try {
            return this.objectMapper.writeValueAsString(message);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot write json for message " + message, e);
        }
    }
}

