/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.sns;

import com.agorapulse.micronaut.amazon.awssdk.core.util.ConfigurationUtil;
import com.agorapulse.micronaut.amazon.awssdk.sns.SimpleNotificationService;
import com.agorapulse.micronaut.amazon.awssdk.sns.annotation.MessageDeduplicationId;
import com.agorapulse.micronaut.amazon.awssdk.sns.annotation.MessageGroupId;
import com.agorapulse.micronaut.amazon.awssdk.sns.annotation.NotificationClient;
import com.agorapulse.micronaut.amazon.awssdk.sns.annotation.Topic;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.services.sns.model.NotFoundException;
import software.amazon.awssdk.services.sns.model.PublishRequest;

@Singleton
public class NotificationClientIntroduction
implements MethodInterceptor<Object, Object> {
    private static final String SUBJECT = "subject";
    private static final String ATTRIBUTES = "attributes";
    private static final String NUMBER = "number";
    private static final String MESSAGE_GROUP_ID = "messageGroupId";
    private static final String MESSAGE_DEDUPLICATION_ID = "messageDeduplicationId";
    private static final Function<String, Optional<String>> EMPTY_IF_UNDEFINED = s -> StringUtils.isEmpty((CharSequence)s) ? Optional.empty() : Optional.of(s);
    private final BeanContext beanContext;
    private final ObjectMapper objectMapper;

    public NotificationClientIntroduction(BeanContext beanContext, ObjectMapper objectMapper) {
        this.beanContext = beanContext;
        this.objectMapper = objectMapper;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        AnnotationValue clientAnnotationValue = context.getAnnotation(NotificationClient.class);
        if (clientAnnotationValue == null) {
            throw new IllegalStateException("Invocation beanContext is missing required annotation NotificationClient");
        }
        String configurationName = clientAnnotationValue.getValue(String.class).orElse("default");
        SimpleNotificationService service = (SimpleNotificationService)this.beanContext.getBean(SimpleNotificationService.class, ConfigurationUtil.isDefaultConfigurationName((String)configurationName) ? null : Qualifiers.byName((String)configurationName));
        String topicName = clientAnnotationValue.get((CharSequence)"topic", String.class).flatMap(EMPTY_IF_UNDEFINED).orElse(null);
        AnnotationValue topicAnnotaitonValue = context.getAnnotation(Topic.class);
        if (topicAnnotaitonValue != null) {
            topicName = (String)topicAnnotaitonValue.getRequiredValue(String.class);
        }
        if (topicName == null) {
            topicName = service.getDefaultTopicNameOrArn();
        }
        try {
            return this.doIntercept(context, service, topicName);
        }
        catch (NotFoundException nfe) {
            service.createTopic(topicName);
            return this.doIntercept(context, service, topicName);
        }
    }

    private Object doIntercept(MethodInvocationContext<Object, Object> context, SimpleNotificationService service, String topicName) {
        Argument[] arguments = context.getArguments();
        Map params = context.getParameterValueMap();
        if (context.getMethodName().toLowerCase().contains("sms")) {
            SmsMessageArguments smsMessageArguments = this.findSmsArguments(arguments);
            String phoneNumber = String.valueOf(params.get(smsMessageArguments.phoneNumber.getName()));
            String message = String.valueOf(params.get(smsMessageArguments.message.getName()));
            Map attributes = Collections.emptyMap();
            if (smsMessageArguments.attributes != null) {
                attributes = (Map)params.get(smsMessageArguments.attributes.getName());
            }
            return service.sendSMSMessage(phoneNumber, message, attributes);
        }
        if (arguments.length >= 1 && arguments.length <= 3) {
            PublishingArguments publishingArguments = this.findArguments(arguments);
            String subject = null;
            if (publishingArguments.subject != null) {
                Object subjectValue = params.get(publishingArguments.subject.getName());
                subject = subjectValue == null ? null : String.valueOf(subjectValue);
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (publishingArguments.attributes != null) {
                Map attrs = (Map)params.get(publishingArguments.attributes.getName());
                attrs.forEach((key, value) -> {
                    if (value != null) {
                        attributes.put((String)key, value.toString());
                    }
                });
            }
            Object message = params.get(publishingArguments.message.getName());
            Class messageType = publishingArguments.message.getType();
            String preparedMessage = "";
            preparedMessage = CharSequence.class.isAssignableFrom(messageType) ? message.toString() : this.toJsonMessage(message);
            if (SimpleNotificationService.isFifoTopic(topicName)) {
                PublishRequest.Builder publishRequestBuilder = PublishRequest.builder();
                publishRequestBuilder.subject(subject);
                publishRequestBuilder.message(preparedMessage);
                if (publishingArguments.messageGroupId != null) {
                    publishRequestBuilder.messageGroupId((String)params.get(publishingArguments.messageGroupId.getName()));
                }
                if (publishingArguments.messageDeduplicationId != null) {
                    publishRequestBuilder.messageDeduplicationId((String)params.get(publishingArguments.messageDeduplicationId.getName()));
                }
                return service.publishRequest(topicName, attributes, publishRequestBuilder);
            }
            return service.publishMessageToTopic(topicName, subject, preparedMessage, attributes);
        }
        throw new UnsupportedOperationException("Cannot implement method " + context.getExecutableMethod());
    }

    private String toJsonMessage(Object message) {
        try {
            return this.objectMapper.writeValueAsString(message);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to marshal " + message + " to JSON", e);
        }
    }

    private PublishingArguments findArguments(Argument[] arguments) {
        PublishingArguments names = new PublishingArguments();
        for (Argument argument : arguments) {
            if (argument.getName().toLowerCase().contains(SUBJECT)) {
                names.subject = argument;
                continue;
            }
            if (Map.class.isAssignableFrom(argument.getType()) && (argument.getName().toLowerCase().contains(ATTRIBUTES) || names.message != null)) {
                names.attributes = argument;
                continue;
            }
            if (argument.getName().equalsIgnoreCase(MESSAGE_GROUP_ID) || argument.isAnnotationPresent(MessageGroupId.class)) {
                names.messageGroupId = argument;
                continue;
            }
            if (argument.getName().equalsIgnoreCase(MESSAGE_DEDUPLICATION_ID) || argument.isAnnotationPresent(MessageDeduplicationId.class)) {
                names.messageDeduplicationId = argument;
                continue;
            }
            names.message = argument;
        }
        if (!names.isValid()) {
            throw new UnsupportedOperationException("Method needs to have at least one argument which name does not contain subject");
        }
        return names;
    }

    private SmsMessageArguments findSmsArguments(Argument[] arguments) {
        SmsMessageArguments names = new SmsMessageArguments();
        for (Argument argument : arguments) {
            if (argument.getName().toLowerCase().contains(NUMBER)) {
                names.phoneNumber = argument;
                continue;
            }
            if (Map.class.isAssignableFrom(argument.getType())) {
                names.attributes = argument;
                continue;
            }
            names.message = argument;
        }
        if (!names.isValid()) {
            throw new UnsupportedOperationException("Method needs to have at least two phone number and message");
        }
        return names;
    }

    private static class SmsMessageArguments {
        Argument<?> message;
        Argument<?> phoneNumber;
        Argument<?> attributes;

        private SmsMessageArguments() {
        }

        boolean isValid() {
            return this.message != null && this.phoneNumber != null;
        }
    }

    private static class PublishingArguments {
        Argument<?> message;
        Argument<?> subject;
        Argument<?> attributes;
        Argument<?> messageGroupId;
        Argument<?> messageDeduplicationId;

        private PublishingArguments() {
        }

        boolean isValid() {
            return this.message != null;
        }
    }
}

