/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.sns;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.Topic;

public interface SimpleNotificationService {
    @Deprecated
    public static final String MOBILE_PLATFORM_ANDROID = "android";
    @Deprecated
    public static final String MOBILE_PLATFORM_IOS = "ios";
    @Deprecated
    public static final String MOBILE_PLATFORM_IOS_SANDBOX = "iosSandbox";
    @Deprecated
    public static final String MOBILE_PLATFORM_AMAZON = "amazon";
    @Deprecated
    public static final String PLATFORM_TYPE_IOS_SANDBOX = "APNS_SANDBOX";
    @Deprecated
    public static final String PLATFORM_TYPE_IOS = "APNS";
    @Deprecated
    public static final String PLATFORM_TYPE_ANDROID = "GCM";
    @Deprecated
    public static final String PLATFORM_TYPE_AMAZON = "ADM";
    public static final String FIFO_SUFFIX = ".fifo";

    public String getPlatformApplicationArn(PlatformType var1);

    @Deprecated
    public String getAmazonApplicationArn();

    @Deprecated
    public String getAndroidApplicationArn();

    @Deprecated
    public String getIosApplicationArn();

    @Deprecated
    public String getIosSandboxApplicationArn();

    public String getDefaultTopicNameOrArn();

    public String createTopic(String var1);

    public Publisher<Topic> listTopics();

    public void deleteTopic(String var1);

    public String subscribeTopic(String var1, String var2, String var3);

    default public String subscribeTopicWithEndpoint(String topicArn, String url) throws MalformedURLException {
        return this.subscribeTopicWithEndpoint(topicArn, new URL(url));
    }

    default public String subscribeTopicWithEndpoint(String topicArn, URL url) {
        if ("https".equals(url.getProtocol())) {
            return this.subscribeTopic(topicArn, "https", url.toExternalForm());
        }
        if ("http".equals(url.getProtocol())) {
            return this.subscribeTopic(topicArn, "http", url.toExternalForm());
        }
        throw new IllegalArgumentException("Can only subscribe to HTTP or HTTPS endpoints!");
    }

    default public String subscribeTopicWithEmail(String topicArn, String email) {
        return this.subscribeTopic(topicArn, "email", email);
    }

    default public String subscribeTopicWithJsonEmail(String topicArn, String email) {
        return this.subscribeTopic(topicArn, "email-json", email);
    }

    default public String subscribeTopicWithSMS(String topicArn, String number) {
        return this.subscribeTopic(topicArn, "sms", number);
    }

    default public String subscribeTopicWithQueue(String topicArn, String queueArn) {
        return this.subscribeTopic(topicArn, "sqs", queueArn);
    }

    default public String subscribeTopicWithApplication(String topicArn, String applicationEndpointArn) {
        return this.subscribeTopic(topicArn, "application", applicationEndpointArn);
    }

    default public String subscribeTopicWithFunction(String topicArn, String lambdaArn) {
        return this.subscribeTopic(topicArn, "lambda", lambdaArn);
    }

    public void unsubscribeTopic(String var1);

    default public String publishMessageToTopic(String topicArn, String subject, String message) {
        return this.publishMessageToTopic(topicArn, subject, message, Collections.emptyMap());
    }

    public String publishMessageToTopic(String var1, String var2, String var3, Map<String, String> var4);

    public String publishRequest(String var1, Map<String, String> var2, PublishRequest.Builder var3);

    public String createPlatformApplication(String var1, PlatformType var2, String var3, String var4);

    @Deprecated
    default public String createPlatformApplication(String name, String platformType, String principal, String credential) {
        return this.createPlatformApplication(name, PlatformType.valueOf(platformType), principal, credential);
    }

    @Deprecated
    default public String createIosApplication(String name, String privateKey, String sslCertificate, boolean sandbox) {
        return this.createPlatformApplication(name, sandbox ? PlatformType.APNS_SANDBOX : PlatformType.APNS, sslCertificate, privateKey);
    }

    @Deprecated
    default public String createAndroidApplication(String name, String apiKey) {
        return this.createPlatformApplication(name, PlatformType.GCM, null, apiKey);
    }

    @Deprecated
    default public String createAmazonApplication(String name, String clientId, String clientSecret) {
        return this.createPlatformApplication(name, PlatformType.ADM, clientId, clientSecret);
    }

    default public String registerDevice(PlatformType platformType, String deviceToken, String customUserData) {
        return this.createPlatformEndpoint(this.getPlatformApplicationArn(platformType), deviceToken, customUserData);
    }

    default public String registerDevice(PlatformType platformType, String deviceToken) {
        return this.registerDevice(platformType, deviceToken, "");
    }

    @Deprecated
    default public String registerDevice(String platform, String deviceToken, String customUserData) {
        if (MOBILE_PLATFORM_ANDROID.equals(platform)) {
            return this.registerAndroidDevice(deviceToken, customUserData);
        }
        if (MOBILE_PLATFORM_IOS.equals(platform)) {
            return this.registerIosDevice(deviceToken, customUserData);
        }
        if (MOBILE_PLATFORM_IOS_SANDBOX.equals(platform)) {
            return this.registerIosSandboxDevice(deviceToken, customUserData);
        }
        if (MOBILE_PLATFORM_AMAZON.equals(platform)) {
            return this.registerAmazonDevice(deviceToken, customUserData);
        }
        throw new IllegalArgumentException("Platform " + platform + " is not supported");
    }

    @Deprecated
    default public String registerDevice(String platform, String deviceToken) {
        return this.registerDevice(platform, deviceToken, "");
    }

    @Deprecated
    default public String registerAndroidDevice(String deviceToken) {
        return this.registerAndroidDevice(deviceToken, "");
    }

    @Deprecated
    default public String registerAndroidDevice(String deviceToken, String customUserData) {
        return this.createPlatformEndpoint(this.getAndroidApplicationArn(), deviceToken, customUserData);
    }

    @Deprecated
    default public String registerAndroidDevice(String applicationArn, String deviceToken, String customUserData) {
        return this.createPlatformEndpoint(applicationArn, deviceToken, customUserData);
    }

    @Deprecated
    default public String registerIosDevice(String deviceToken) {
        return this.registerIosDevice(deviceToken, "");
    }

    @Deprecated
    default public String registerIosDevice(String deviceToken, String customUserData) {
        return this.createPlatformEndpoint(this.getIosApplicationArn(), deviceToken, customUserData);
    }

    @Deprecated
    default public String registerIosSandboxDevice(String deviceToken) {
        return this.registerIosSandboxDevice(deviceToken, "");
    }

    @Deprecated
    default public String registerIosSandboxDevice(String deviceToken, String customUserData) {
        return this.createPlatformEndpoint(this.getIosSandboxApplicationArn(), deviceToken, customUserData);
    }

    @Deprecated
    default public String registerIosDevice(String applicationArn, String deviceToken, String customUserData) {
        return this.createPlatformEndpoint(applicationArn, deviceToken, customUserData);
    }

    @Deprecated
    default public String registerAmazonDevice(String deviceToken) {
        return this.registerAmazonDevice(deviceToken, "");
    }

    @Deprecated
    default public String registerAmazonDevice(String deviceToken, String customUserData) {
        return this.registerAmazonDevice(this.getAmazonApplicationArn(), deviceToken, customUserData);
    }

    @Deprecated
    default public String registerAmazonDevice(String applicationArn, String deviceToken, String customUserData) {
        return this.createPlatformEndpoint(applicationArn, deviceToken, customUserData);
    }

    public String createPlatformEndpoint(String var1, String var2, String var3);

    default public String createPlatformEndpoint(String platformApplicationArn, String deviceToken) {
        return this.createPlatformEndpoint(platformApplicationArn, deviceToken, null);
    }

    @Deprecated
    public String sendAndroidAppNotification(String var1, Map<String, Object> var2, String var3, boolean var4, int var5, boolean var6);

    @Deprecated
    default public String sendAndroidAppNotification(String endpointArn, Map<String, Object> notification, String collapseKey, boolean delayWhileIdle, int timeToLive) {
        return this.sendAndroidAppNotification(endpointArn, notification, collapseKey, delayWhileIdle, timeToLive, false);
    }

    @Deprecated
    default public String sendAndroidAppNotification(String endpointArn, Map<String, Object> notification, String collapseKey, boolean delayWhileIdle) {
        return this.sendAndroidAppNotification(endpointArn, notification, collapseKey, delayWhileIdle, 125);
    }

    @Deprecated
    default public String sendAndroidAppNotification(String endpointArn, Map<String, Object> notification, String collapseKey) {
        return this.sendAndroidAppNotification(endpointArn, notification, collapseKey, true);
    }

    @Deprecated
    public String sendIosAppNotification(String var1, Map<String, Object> var2, boolean var3);

    @Deprecated
    default public String sendIosAppNotification(String endpointArn, Map<String, Object> notification) {
        return this.sendIosAppNotification(endpointArn, notification, false);
    }

    @Deprecated
    default public String validateAmazonDevice(String endpointArn, String deviceToken, String customUserData) {
        return this.validateDeviceToken(this.getAmazonApplicationArn(), endpointArn, deviceToken, customUserData);
    }

    @Deprecated
    default public String validateAmazonDevice(String endpointArn, String deviceToken) {
        return this.validateAmazonDevice(endpointArn, deviceToken, "");
    }

    @Deprecated
    default public String validateAndroidDevice(String applicationArn, String endpointArn, String deviceToken, String customUserData) {
        return this.validateDeviceToken(applicationArn, endpointArn, deviceToken, customUserData);
    }

    @Deprecated
    default public String validateAndroidDevice(String endpointArn, String deviceToken, String customUserData) {
        return this.validateDeviceToken(this.getAndroidApplicationArn(), endpointArn, deviceToken, customUserData);
    }

    @Deprecated
    default public String validateAndroidDevice(String endpointArn, String deviceToken) {
        return this.validateAndroidDevice(endpointArn, deviceToken, "");
    }

    @Deprecated
    default public String validateIosDevice(String applicationArn, String endpointArn, String deviceToken, String customUserData) {
        return this.validateDeviceToken(applicationArn, endpointArn, deviceToken, customUserData);
    }

    @Deprecated
    default public String validateIosDevice(String endpointArn, String deviceToken, String customUserData) {
        return this.validateDeviceToken(this.getIosApplicationArn(), endpointArn, deviceToken, customUserData);
    }

    @Deprecated
    default public String validateIosDevice(String endpointArn, String deviceToken) {
        return this.validateIosDevice(endpointArn, deviceToken, "");
    }

    @Deprecated
    default public String validateIosSandboxDevice(String endpointArn, String deviceToken, String customUserData) {
        return this.validateDeviceToken(this.getIosSandboxApplicationArn(), endpointArn, deviceToken, customUserData);
    }

    @Deprecated
    default public String validateIosSandboxDevice(String endpointArn, String deviceToken) {
        return this.validateIosSandboxDevice(endpointArn, deviceToken, "");
    }

    default public String validateDeviceToken(PlatformType platformType, String endpointArn, String deviceToken, String customUserData) {
        return this.validateDeviceToken(this.getPlatformApplicationArn(platformType), endpointArn, deviceToken, customUserData);
    }

    public String validateDeviceToken(String var1, String var2, String var3, String var4);

    @Deprecated
    default public String validateDevice(String platform, String endpointArn, String deviceToken, String customUserData) {
        if (MOBILE_PLATFORM_AMAZON.equals(platform)) {
            return this.validateAmazonDevice(endpointArn, deviceToken, customUserData);
        }
        if (MOBILE_PLATFORM_ANDROID.equals(platform)) {
            return this.validateAndroidDevice(endpointArn, deviceToken, customUserData);
        }
        if (MOBILE_PLATFORM_IOS.equals(platform)) {
            return this.validateIosDevice(endpointArn, deviceToken, customUserData);
        }
        if (MOBILE_PLATFORM_IOS_SANDBOX.equals(platform)) {
            return this.validateIosSandboxDevice(endpointArn, deviceToken, customUserData);
        }
        return null;
    }

    @Deprecated
    default public String validateDevice(String platform, String endpointArn, String deviceToken) {
        return this.validateDevice(platform, endpointArn, deviceToken, "");
    }

    public void unregisterDevice(String var1);

    public String sendNotification(String var1, PlatformType var2, String var3);

    public String sendSMSMessage(String var1, String var2, Map<String, MessageAttributeValue> var3);

    default public String sendSMSMessage(String phoneNumber, String message) {
        return this.sendSMSMessage(phoneNumber, message, Collections.emptyMap());
    }

    public static boolean isFifoTopic(String topicName) {
        return topicName.endsWith(FIFO_SUFFIX);
    }

    public static enum PlatformType {
        ADM,
        APNS,
        APNS_SANDBOX,
        GCM;

    }
}

