/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.sns;

import com.agorapulse.micronaut.amazon.awssdk.core.DefaultRegionAndEndpointConfiguration;
import io.micronaut.context.env.Environment;

public abstract class SimpleNotificationServiceConfiguration
extends DefaultRegionAndEndpointConfiguration {
    private final Application apns;
    private final Application apnsSandbox;
    private final Application gcm;
    private final Application adm;
    private String topic = "";

    protected SimpleNotificationServiceConfiguration(String prefix, Environment environment) {
        this.apns = SimpleNotificationServiceConfiguration.forPlatform(prefix, "apns", "ios", environment);
        this.apnsSandbox = SimpleNotificationServiceConfiguration.forPlatform(prefix, "apns-sandbox", "ios-sandbox", environment);
        this.gcm = SimpleNotificationServiceConfiguration.forPlatform(prefix, "gcm", "android", environment);
        this.adm = SimpleNotificationServiceConfiguration.forPlatform(prefix, "adm", "amazon", environment);
    }

    private static Application forPlatform(String prefix, String platform, String fallbackPlatform, Environment environment) {
        return new Application(environment.get((CharSequence)(prefix + "." + platform + ".arn"), String.class).orElseGet(() -> environment.get((CharSequence)(prefix + "." + platform + ".applicationArn"), String.class).orElseGet(() -> environment.get((CharSequence)(prefix + "." + fallbackPlatform + ".arn"), String.class).orElseGet(() -> environment.get((CharSequence)(prefix + "." + fallbackPlatform + ".applicationArn"), String.class).orElse(null)))));
    }

    @Deprecated
    public final Application getIos() {
        return this.apns;
    }

    @Deprecated
    public final Application getIosSandbox() {
        return this.apnsSandbox;
    }

    @Deprecated
    public final Application getAndroid() {
        return this.gcm;
    }

    @Deprecated
    public final Application getAmazon() {
        return this.adm;
    }

    public Application getApns() {
        return this.apns;
    }

    public Application getApnsSandbox() {
        return this.apnsSandbox;
    }

    public Application getGcm() {
        return this.gcm;
    }

    public Application getAdm() {
        return this.adm;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public static class Application {
        private final String arn;

        public Application(String arn) {
            this.arn = arn;
        }

        public final String getArn() {
            return this.arn;
        }
    }
}

