/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.sns;

import com.agorapulse.micronaut.amazon.awssdk.sns.DefaultSimpleNotificationService;
import com.agorapulse.micronaut.amazon.awssdk.sns.SimpleNotificationService;
import com.agorapulse.micronaut.amazon.awssdk.sns.SimpleNotificationServiceConfiguration;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import jakarta.inject.Singleton;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClientBuilder;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;

@Factory
public class SimpleNotificationServiceFactory {
    @Singleton
    @EachBean(value=SimpleNotificationServiceConfiguration.class)
    SnsClient snsClient(AwsCredentialsProvider credentialsProvider, AwsRegionProvider awsRegionProvider, SimpleNotificationServiceConfiguration configuration) {
        return (SnsClient)((SnsClientBuilder)((SnsClientBuilder)configuration.configure((AwsClientBuilder)SnsClient.builder(), awsRegionProvider)).credentialsProvider(credentialsProvider)).build();
    }

    @Singleton
    @EachBean(value=SimpleNotificationServiceConfiguration.class)
    SnsAsyncClient snsAsyncClient(AwsCredentialsProvider credentialsProvider, AwsRegionProvider awsRegionProvider, SimpleNotificationServiceConfiguration configuration, Optional<SdkAsyncHttpClient> httpClient) {
        SnsAsyncClientBuilder builder = (SnsAsyncClientBuilder)SnsAsyncClient.builder().credentialsProvider(credentialsProvider);
        configuration.configure((AwsClientBuilder)builder, awsRegionProvider);
        httpClient.ifPresent(arg_0 -> ((SnsAsyncClientBuilder)builder).httpClient(arg_0));
        return (SnsAsyncClient)builder.build();
    }

    @Singleton
    @EachBean(value=SimpleNotificationServiceConfiguration.class)
    SimpleNotificationService simpleQueueService(SnsClient sqs, SimpleNotificationServiceConfiguration configuration, ObjectMapper mapper) {
        return new DefaultSimpleNotificationService(sqs, configuration, mapper);
    }
}

