/*
 * Decompiled with CFR 0.152.
 */
package com.ait.tooling.server.mongodb;

import com.ait.tooling.common.api.java.util.StringOps;
import com.ait.tooling.server.core.json.JSONUtils;
import com.ait.tooling.server.mongodb.support.spring.IMongoDBCollectionOptions;
import com.ait.tooling.server.mongodb.support.spring.IMongoDBOptions;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.UpdateOptions;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.bson.BSON;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.Transformer;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public final class MongoDB {
    private static final Logger logger = Logger.getLogger(MongoDB.class);
    private final MongoClient m_mongo;
    private final String m_usedb;
    private final boolean m_useid;
    private final Map<String, IMongoDBOptions> m_dbops;

    private static final Map<String, Object> CAST_MAP(Map<String, ?> map) {
        return Objects.requireNonNull(map);
    }

    public MongoDB(List<ServerAddress> addr, List<MongoCredential> auth, MongoClientOptions opts, boolean repl, String usedb, boolean useid, Map<String, IMongoDBOptions> dbops) {
        this.m_useid = useid;
        this.m_dbops = Objects.requireNonNull(dbops);
        this.m_usedb = StringOps.requireTrimOrNull((String)usedb);
        BSON.addEncodingHook(BigDecimal.class, (Transformer)new Transformer(){

            public Object transform(Object object) {
                if (null == object) {
                    return null;
                }
                return JSONUtils.asDouble((Object)object);
            }
        });
        BSON.addEncodingHook(BigInteger.class, (Transformer)new Transformer(){

            public Object transform(Object object) {
                if (null == object) {
                    return null;
                }
                Long lval = JSONUtils.asLong((Object)object);
                if (null != lval) {
                    return lval;
                }
                return JSONUtils.asInteger((Object)object);
            }
        });
        if (addr.isEmpty()) {
            throw new IllegalArgumentException("no ServerAddress");
        }
        if (addr.size() == 1 && !repl) {
            ServerAddress main = addr.get(0);
            if (null == main) {
                throw new IllegalArgumentException("null ServerAddress");
            }
            this.m_mongo = null == auth || auth.isEmpty() ? new MongoClient(main, Objects.requireNonNull(opts)) : new MongoClient(main, auth, Objects.requireNonNull(opts));
        } else {
            this.m_mongo = null == auth || auth.isEmpty() ? new MongoClient(addr, Objects.requireNonNull(opts)) : new MongoClient(addr, auth, Objects.requireNonNull(opts));
        }
    }

    public boolean isAddingID() {
        return this.m_useid;
    }

    public void close() {
        if (null != this.m_mongo) {
            this.m_mongo.close();
        }
    }

    public List<String> getDatabaseNames() {
        return (List)this.m_mongo.listDatabaseNames().into(new ArrayList());
    }

    public final MDatabase db(String name) throws Exception {
        return this.db(StringOps.requireTrimOrNull((String)name), this.isAddingID());
    }

    public final MDatabase db() throws Exception {
        return this.db(this.m_usedb, this.isAddingID());
    }

    public final MDatabase db(String name, boolean id) throws Exception {
        IMongoDBOptions op = this.m_dbops.get(name = StringOps.requireTrimOrNull((String)name));
        if (null != op) {
            id = op.isCreateID();
        }
        return new MDatabase(this.m_mongo.getDatabase(name), id, op);
    }

    public static class MQuery
    extends Document {
        private MQuery() {
        }

        public MQuery(Map<String, ?> map) {
            super(Objects.requireNonNull(map));
        }

        public static final MQuery QUERY(Map<String, ?> map) {
            return new MQuery(map);
        }

        public static final <T> MQuery EQ(String name, T value) {
            return MQuery.convert(Filters.eq((String)StringOps.requireTrimOrNull((String)name), value));
        }

        public static final <T> MQuery NE(String name, T value) {
            return MQuery.convert(Filters.ne((String)StringOps.requireTrimOrNull((String)name), value));
        }

        public static final <T> MQuery GT(String name, T value) {
            return MQuery.convert(Filters.gt((String)StringOps.requireTrimOrNull((String)name), value));
        }

        public static final <T> MQuery LT(String name, T value) {
            return MQuery.convert(Filters.lt((String)StringOps.requireTrimOrNull((String)name), value));
        }

        public static final <T> MQuery GTE(String name, T value) {
            return MQuery.convert(Filters.gte((String)StringOps.requireTrimOrNull((String)name), value));
        }

        public static final <T> MQuery LTE(String name, T value) {
            return MQuery.convert(Filters.lte((String)StringOps.requireTrimOrNull((String)name), value));
        }

        @SafeVarargs
        public static final <T> MQuery IN(String name, T ... list) {
            return MQuery.IN(StringOps.requireTrimOrNull((String)name), Arrays.asList(list));
        }

        public static final <T> MQuery IN(String name, List<T> list) {
            return MQuery.convert(Filters.in((String)StringOps.requireTrimOrNull((String)name), (Iterable)Objects.requireNonNull(list)));
        }

        @SafeVarargs
        public static final <T> MQuery NIN(String name, T ... list) {
            return MQuery.NIN(StringOps.requireTrimOrNull((String)name), Arrays.asList(list));
        }

        public static final <T> MQuery NIN(String name, List<T> list) {
            return MQuery.convert(Filters.nin((String)StringOps.requireTrimOrNull((String)name), (Iterable)Objects.requireNonNull(list)));
        }

        public static final MQuery AND(MQuery ... list) {
            return MQuery.AND(Arrays.asList(list));
        }

        public static final MQuery AND(List<MQuery> list) {
            return MQuery.convert(Filters.and(new ArrayList(Objects.requireNonNull(list))));
        }

        public static final MQuery OR(MQuery ... list) {
            return MQuery.OR(Arrays.asList(list));
        }

        public static final MQuery OR(List<MQuery> list) {
            return MQuery.convert(Filters.or(new ArrayList(Objects.requireNonNull(list))));
        }

        public static final MQuery NOT(MQuery query) {
            return MQuery.convert(Filters.not((Bson)((Bson)Objects.requireNonNull(query))));
        }

        public static final MQuery EXISTS(String name, boolean exists) {
            return MQuery.convert(Filters.exists((String)StringOps.requireTrimOrNull((String)name), (boolean)exists));
        }

        public static final MQuery EXISTS(String name) {
            return MQuery.convert(Filters.exists((String)StringOps.requireTrimOrNull((String)name), (boolean)true));
        }

        private static final MQuery convert(final Bson b) {
            return new MQuery(){

                public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                    return b.toBsonDocument(documentClass, codecRegistry);
                }
            };
        }
    }

    public static final class MProjection
    extends Document {
        private static final BsonInt32 INCLUDE_N = new BsonInt32(0);
        private static final BsonInt32 INCLUDE_Y = new BsonInt32(1);

        private MProjection() {
        }

        public MProjection(Map<String, ?> map) {
            super(Objects.requireNonNull(map));
        }

        private MProjection(String name, BsonValue value) {
            super(StringOps.requireTrimOrNull((String)name), (Object)value);
        }

        public static final MProjection INCLUDE(String ... fields) {
            return MProjection.INCLUDE(Arrays.asList(fields));
        }

        public static final MProjection INCLUDE(List<String> fields) {
            return MProjection.COMBINE(Objects.requireNonNull(fields), INCLUDE_Y);
        }

        public static final MProjection EXCLUDE(String ... fields) {
            return MProjection.EXCLUDE(Arrays.asList(fields));
        }

        public static final MProjection EXCLUDE(List<String> fields) {
            return MProjection.COMBINE(Objects.requireNonNull(fields), INCLUDE_N);
        }

        public static final MProjection NO_ID() {
            return new MProjection("_id", (BsonValue)INCLUDE_N);
        }

        public static final MProjection FIELDS(MProjection ... projections) {
            return MProjection.FIELDS(Arrays.asList(projections));
        }

        public static final MProjection FIELDS(List<MProjection> projections) {
            MProjection projection = new MProjection();
            for (MProjection p : projections) {
                for (String k : p.keySet()) {
                    if (null == (k = StringOps.toTrimOrNull((String)k))) continue;
                    projection.remove(k);
                    projection.append(k, p.get(k));
                }
            }
            return projection;
        }

        private static final MProjection COMBINE(List<String> fields, BsonInt32 value) {
            MProjection projection = new MProjection();
            for (String name : fields) {
                if (null == (name = StringOps.toTrimOrNull((String)name))) continue;
                projection.remove(name);
                projection.append(name, value);
            }
            return projection;
        }
    }

    public static final class MSort
    extends Document {
        private static final BsonInt32 ORDER_A = new BsonInt32(1);
        private static final BsonInt32 ORDER_D = new BsonInt32(-1);

        private MSort() {
        }

        public MSort(Map<String, ?> map) {
            super(map);
        }

        public static final MSort ASCENDING(String ... fields) {
            return MSort.ASCENDING(Arrays.asList(fields));
        }

        public static final MSort ASCENDING(List<String> fields) {
            return MSort.ORDER_BY(Objects.requireNonNull(fields), ORDER_A);
        }

        public static final MSort DESCENDING(String ... fields) {
            return MSort.DESCENDING(Arrays.asList(fields));
        }

        public static final MSort DESCENDING(List<String> fields) {
            return MSort.ORDER_BY(Objects.requireNonNull(fields), ORDER_D);
        }

        public static final MSort ORDER_BY(MSort ... sorts) {
            return MSort.ORDER_BY(Arrays.asList(sorts));
        }

        public static final MSort ORDER_BY(List<MSort> sorts) {
            Objects.requireNonNull(sorts);
            MSort sort = new MSort();
            for (MSort s : sorts) {
                if (null != s) {
                    for (String k : s.keySet()) {
                        if (null == StringOps.toTrimOrNull((String)k)) continue;
                        sort.remove(k);
                        sort.append(k, s.get(k));
                    }
                    continue;
                }
                logger.warn((Object)"MSort.ORDER_BY(null)");
            }
            return sort;
        }

        private static final MSort ORDER_BY(List<String> fields, BsonInt32 value) {
            Objects.requireNonNull(fields);
            MSort sort = new MSort();
            for (String name : fields) {
                if (null == StringOps.toTrimOrNull((String)name)) continue;
                sort.remove(name);
                sort.append(name, value);
            }
            return sort;
        }
    }

    public static final class MCursor
    extends AbstractMCursor<FindIterable<Document>> {
        protected MCursor(FindIterable<Document> finder) {
            super(finder);
        }

        public MCursor projection(MProjection projection) {
            return new MCursor((FindIterable<Document>)((FindIterable)this.self()).projection((Bson)Objects.requireNonNull(projection)));
        }

        public MCursor skip(int skip) {
            return new MCursor((FindIterable<Document>)((FindIterable)this.self()).skip(Math.max(0, skip)));
        }

        public MCursor limit(int limit) {
            return new MCursor((FindIterable<Document>)((FindIterable)this.self()).limit(Math.max(0, limit)));
        }

        public MCursor sort(Map<String, ?> sort) {
            return this.sort(new MSort(Objects.requireNonNull(sort)));
        }

        public MCursor sort(MSort sort) {
            return new MCursor((FindIterable<Document>)((FindIterable)this.self()).sort((Bson)Objects.requireNonNull(sort)));
        }
    }

    public static final class MAggregateCursor
    extends AbstractMCursor<AggregateIterable<Document>> {
        protected MAggregateCursor(AggregateIterable<Document> aggreg) {
            super(aggreg);
        }
    }

    public static final class MIndexCursor
    extends AbstractMCursor<ListIndexesIterable<Document>> {
        protected MIndexCursor(ListIndexesIterable<Document> index) {
            super(index);
        }
    }

    protected static abstract class AbstractMCursor<T extends MongoIterable<Document>>
    implements IMCursor {
        private final T m_iterab;
        private final MongoCursor<Document> m_cursor;
        private boolean m_closed = false;
        private boolean m_autoclose = true;

        protected AbstractMCursor(T iter) {
            this.m_iterab = (MongoIterable)Objects.requireNonNull(iter);
            this.m_cursor = Objects.requireNonNull(this.m_iterab.iterator());
        }

        protected final T self() {
            return this.m_iterab;
        }

        @Override
        public <A extends Collection<? super Map<String, ?>>> A into(A target) {
            Collection result = this.m_iterab.into(target);
            try {
                this.close();
            }
            catch (IOException e) {
                logger.error((Object)"Error in AbstractMCursor.into() ", (Throwable)e);
            }
            return (A)result;
        }

        @Override
        public Iterator<Map<String, ?>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            boolean next;
            boolean bl = next = !this.m_closed && this.m_cursor.hasNext();
            if (!next && !this.m_closed && this.m_autoclose) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Error in AbstractMCursor.close() ", (Throwable)e);
                }
            }
            return next;
        }

        public void setAutoClose(boolean autoclose) {
            this.m_autoclose = autoclose;
        }

        @Override
        public Map<String, ?> next() {
            return (Map)this.m_cursor.next();
        }

        @Override
        public void remove() {
            this.m_cursor.remove();
        }

        @Override
        public void close() throws IOException {
            if (!this.m_closed) {
                this.m_cursor.close();
                this.m_closed = true;
            }
        }
    }

    public static interface IMCursor
    extends Iterable<Map<String, ?>>,
    Iterator<Map<String, ?>>,
    Closeable {
        public <A extends Collection<? super Map<String, ?>>> A into(A var1);
    }

    public static final class MAggregationPipeline {
        private final ArrayList<Document> m_pipeline = new ArrayList();

        public <T extends Document> MAggregationPipeline(List<T> list) {
            this.m_pipeline.addAll((Collection<Document>)Objects.requireNonNull(list));
        }

        @SafeVarargs
        public <T extends Document> MAggregationPipeline(T ... list) {
            this.m_pipeline.addAll(Arrays.asList(Objects.requireNonNull(list)));
        }

        List<Document> list() {
            return this.m_pipeline;
        }
    }

    public static final class MAggregationMatch
    extends MAggregationOp {
        private static final long serialVersionUID = -1138722876045817851L;

        public MAggregationMatch(Map<String, ?> map) {
            super(MAggregationMatch.makeAggregationOp("$match", Objects.requireNonNull(map)));
        }

        public MAggregationMatch(Document doc) {
            super(MAggregationMatch.makeAggregationOp("$match", Objects.requireNonNull(doc)));
        }
    }

    public static final class MAggregationGroup
    extends MAggregationOp {
        private static final long serialVersionUID = 3079372174680166319L;

        public MAggregationGroup(Map<String, ?> map) {
            super(MAggregationGroup.makeAggregationOp("$group", Objects.requireNonNull(map)));
        }

        public MAggregationGroup(Document doc) {
            super(MAggregationGroup.makeAggregationOp("$group", Objects.requireNonNull(doc)));
        }
    }

    private static class MAggregationOp
    extends Document {
        private MAggregationOp(Document doc) {
            super((Map)Objects.requireNonNull(doc));
        }

        protected static final MAggregationOp makeAggregationOp(String op, Map<String, ?> map) {
            LinkedHashMap make = new LinkedHashMap(1);
            make.put(Objects.requireNonNull(op), Objects.requireNonNull(map));
            return new MAggregationOp(new Document(make));
        }

        protected static final MAggregationOp makeAggregationOp(String op, Document doc) {
            LinkedHashMap<String, Document> make = new LinkedHashMap<String, Document>(1);
            make.put(Objects.requireNonNull(op), Objects.requireNonNull(doc));
            return new MAggregationOp(new Document(make));
        }

        public static final MAggregationMatch MATCH(Map<String, ?> map) {
            return new MAggregationMatch(Objects.requireNonNull(map));
        }

        public static final MAggregationMatch MATCH(Document doc) {
            return new MAggregationMatch(Objects.requireNonNull(doc));
        }

        public static final MAggregationGroup GROUP(Map<String, ?> map) {
            return new MAggregationGroup(Objects.requireNonNull(map));
        }

        public static final MAggregationGroup GROUP(Document doc) {
            return new MAggregationGroup(Objects.requireNonNull(doc));
        }
    }

    public static final class MCollection {
        private final MongoCollection<Document> m_collection;
        private final boolean m_id;

        protected MCollection(MongoCollection<Document> collection, boolean id) {
            this.m_collection = Objects.requireNonNull(collection);
            this.m_id = id;
        }

        public boolean isCreateID() {
            return this.m_id;
        }

        public final String getName() {
            return this.m_collection.getNamespace().getCollectionName();
        }

        public final String createIndex(Map<String, ?> keys) {
            return this.m_collection.createIndex((Bson)new Document(MongoDB.CAST_MAP(keys)));
        }

        public final String createIndex(Map<String, ?> keys, String name) {
            return this.m_collection.createIndex((Bson)new Document(MongoDB.CAST_MAP(keys)), new IndexOptions().name(Objects.requireNonNull(name)));
        }

        public final String createIndex(Map<String, ?> keys, IndexOptions opts) {
            return this.m_collection.createIndex((Bson)new Document(MongoDB.CAST_MAP(keys)), Objects.requireNonNull(opts));
        }

        public final MCollection dropIndex(String name) {
            this.m_collection.dropIndex(Objects.requireNonNull(name));
            return this;
        }

        public final MCollection dropIndexes() {
            this.m_collection.dropIndexes();
            return this;
        }

        public final MIndexCursor getIndexes() {
            return new MIndexCursor((ListIndexesIterable<Document>)this.m_collection.listIndexes());
        }

        @SafeVarargs
        public final <T extends Document> MAggregateCursor aggregate(T ... list) {
            return this.aggregate(new MAggregationPipeline((Document[])Objects.requireNonNull(list)));
        }

        public final <T extends Document> MAggregateCursor aggregate(List<T> list) {
            return this.aggregate(new MAggregationPipeline(Objects.requireNonNull(list)));
        }

        public final MAggregateCursor aggregate(MAggregationPipeline pipeline) {
            return new MAggregateCursor((AggregateIterable<Document>)this.m_collection.aggregate(Objects.requireNonNull(pipeline.list())));
        }

        public final void drop() {
            this.m_collection.drop();
        }

        public final MCollection deleteMany(Map<String, ?> query) {
            return this.deleteMany(new MQuery(Objects.requireNonNull(query)));
        }

        public final MCollection deleteMany(MQuery query) {
            this.m_collection.deleteMany((Bson)Objects.requireNonNull(query));
            return this;
        }

        public final MCollection deleteOne(Map<String, ?> query) {
            return this.deleteOne(new MQuery(Objects.requireNonNull(query)));
        }

        public final MCollection deleteOne(MQuery query) {
            this.m_collection.deleteOne((Bson)Objects.requireNonNull(query));
            return this;
        }

        public final Map<String, ?> ensureHasID(Map<String, ?> update) {
            Objects.requireNonNull(update);
            Object id = update.get("id");
            if (!(id instanceof String) || null == StringOps.toTrimOrNull((String)id.toString())) {
                update.put("id", new ObjectId().toString());
            }
            return update;
        }

        public final Map<String, ?> insertOne(Map<String, ?> record) {
            if (this.isCreateID()) {
                Map<String, ?> withid = this.ensureHasID(Objects.requireNonNull(record));
                this.m_collection.insertOne((Object)new Document(MongoDB.CAST_MAP(withid)));
                return withid;
            }
            this.m_collection.insertOne((Object)new Document(MongoDB.CAST_MAP(record)));
            return record;
        }

        public final MCollection insertMany(List<Map<String, ?>> list) {
            Objects.requireNonNull(list);
            if (list.isEmpty()) {
                logger.warn((Object)"MCollection.insertMany(empty)");
                return this;
            }
            if (1 == list.size()) {
                this.insertOne(Objects.requireNonNull(list.get(0)));
                return this;
            }
            ArrayList<Document> save = new ArrayList<Document>(list.size());
            if (this.isCreateID()) {
                for (Map<String, ?> lmap : list) {
                    save.add(new Document(MongoDB.CAST_MAP(this.ensureHasID(lmap))));
                }
            } else {
                for (Map<String, ?> lmap : list) {
                    save.add(new Document(MongoDB.CAST_MAP(this.ensureHasID(lmap))));
                }
            }
            this.m_collection.insertMany(save);
            return this;
        }

        public final long count() {
            return this.m_collection.count();
        }

        public final long count(Map<String, ?> query) {
            return this.count(new MQuery(Objects.requireNonNull(query)));
        }

        public final long count(MQuery query) {
            return this.m_collection.count((Bson)Objects.requireNonNull(query));
        }

        public final MCursor find() throws Exception {
            return this.find(false);
        }

        final String getNameSpace() {
            return this.m_collection.getNamespace().toString();
        }

        public final MCursor find(boolean with_id) throws Exception {
            if (with_id) {
                return new MCursor((FindIterable<Document>)this.m_collection.find());
            }
            return new MCursor((FindIterable<Document>)this.m_collection.find().projection((Bson)MProjection.NO_ID()));
        }

        public final MCursor find(Map<String, ?> query) throws Exception {
            return this.find(new MQuery(Objects.requireNonNull(query)), false);
        }

        public final MCursor find(MQuery query) throws Exception {
            return this.find(Objects.requireNonNull(query), false);
        }

        public final MCursor find(Map<String, ?> query, boolean with_id) throws Exception {
            return this.find(new MQuery(Objects.requireNonNull(query)), with_id);
        }

        public final MCursor find(MQuery query, boolean with_id) throws Exception {
            if (with_id) {
                return new MCursor((FindIterable<Document>)this.m_collection.find((Bson)Objects.requireNonNull(query)));
            }
            return new MCursor((FindIterable<Document>)this.m_collection.find((Bson)Objects.requireNonNull(query)).projection((Bson)MProjection.NO_ID()));
        }

        public final MCursor find(Map<String, ?> query, Map<String, ?> fields) throws Exception {
            return this.find(new MQuery(Objects.requireNonNull(query)), new MProjection(Objects.requireNonNull(fields)));
        }

        public final MCursor find(MQuery query, Map<String, ?> fields) throws Exception {
            return this.find(Objects.requireNonNull(query), new MProjection(Objects.requireNonNull(fields)));
        }

        public final MCursor find(Map<String, ?> query, MProjection fields) throws Exception {
            return this.find(new MQuery(Objects.requireNonNull(query)), Objects.requireNonNull(fields), false);
        }

        public final MCursor find(MQuery query, MProjection fields) throws Exception {
            return this.find(Objects.requireNonNull(query), Objects.requireNonNull(fields), false);
        }

        public final MCursor find(Map<String, ?> query, Map<String, ?> fields, boolean with_id) throws Exception {
            return this.find(new MQuery(Objects.requireNonNull(query)), new MProjection(Objects.requireNonNull(fields)), with_id);
        }

        public final MCursor find(Map<String, ?> query, MProjection fields, boolean with_id) throws Exception {
            return this.find(new MQuery(Objects.requireNonNull(query)), Objects.requireNonNull(fields), with_id);
        }

        public final MCursor find(MQuery query, MProjection fields, boolean with_id) throws Exception {
            if (with_id) {
                return new MCursor((FindIterable<Document>)this.m_collection.find((Bson)Objects.requireNonNull(query)).projection((Bson)Objects.requireNonNull(fields)));
            }
            return new MCursor((FindIterable<Document>)this.m_collection.find((Bson)Objects.requireNonNull(query)).projection((Bson)MProjection.FIELDS(Objects.requireNonNull(fields), MProjection.NO_ID())));
        }

        public final Map<String, ?> findAndModify(Map<String, ?> query, Map<String, ?> update) {
            return this.update(new MQuery(Objects.requireNonNull(query)), Objects.requireNonNull(update), false, true);
        }

        public final Map<String, ?> findAndModify(MQuery query, Map<String, ?> update) {
            return this.update(Objects.requireNonNull(query), Objects.requireNonNull(update), false, true);
        }

        public final Map<String, ?> upsert(Map<String, ?> query, Map<String, ?> update) {
            return this.upsert(new MQuery(Objects.requireNonNull(query)), Objects.requireNonNull(update));
        }

        public final Map<String, ?> upsert(MQuery query, Map<String, ?> update) {
            return this.update(Objects.requireNonNull(query), Objects.requireNonNull(update), true, true);
        }

        public final Map<String, ?> create(Map<String, ?> record) {
            return this.insertOne(Objects.requireNonNull(record));
        }

        public final Map<String, ?> update(Map<String, ?> query, Map<String, ?> update, boolean upsert, boolean multi) {
            return this.update(new MQuery(Objects.requireNonNull(query)), Objects.requireNonNull(update), upsert, multi);
        }

        public final Map<String, ?> update(MQuery query, Map<String, ?> update, boolean upsert, boolean multi) {
            if (multi) {
                this.m_collection.updateMany((Bson)Objects.requireNonNull(query), (Bson)new Document(MongoDB.CAST_MAP(update)), new UpdateOptions().upsert(upsert));
            } else {
                this.m_collection.updateOne((Bson)Objects.requireNonNull(query), (Bson)new Document(MongoDB.CAST_MAP(update)), new UpdateOptions().upsert(upsert));
            }
            return update;
        }

        public final Map<String, ?> findOne(Map<String, ?> query) {
            return this.findOne(new MQuery(Objects.requireNonNull(query)));
        }

        public final Map<String, ?> findOne(MQuery query) {
            FindIterable iter = this.m_collection.find((Bson)Objects.requireNonNull(query)).limit(1).projection((Bson)MProjection.NO_ID());
            if (null != iter) {
                return (Map)iter.first();
            }
            return null;
        }

        public final boolean updateOne(Map<String, ?> query, Map<String, ?> update) {
            return this.updateOne(new MQuery(Objects.requireNonNull(query)), Objects.requireNonNull(update));
        }

        public final boolean updateOne(MQuery query, Map<String, ?> update) {
            return this.m_collection.updateOne((Bson)Objects.requireNonNull(query), (Bson)new Document(MongoDB.CAST_MAP(update))).getModifiedCount() == 1L;
        }

        public final long updateMany(Map<String, ?> query, Map<String, ?> update) {
            return this.updateMany(new MQuery(Objects.requireNonNull(query)), Objects.requireNonNull(update));
        }

        public final long updateMany(MQuery query, Map<String, ?> update) {
            return this.m_collection.updateMany((Bson)Objects.requireNonNull(query), (Bson)new Document(MongoDB.CAST_MAP(update)), new UpdateOptions().upsert(false)).getModifiedCount();
        }

        public final List<?> distinct(String field) {
            return (List)this.m_collection.distinct(StringOps.requireTrimOrNull((String)field), Document.class).into(new ArrayList());
        }

        public final List<?> distinct(String field, Map<String, ?> query) {
            return (List)this.m_collection.distinct(StringOps.requireTrimOrNull((String)field), Document.class).filter((Bson)new Document(MongoDB.CAST_MAP(query))).into(new ArrayList());
        }
    }

    public static final class MCollectionPreferences {
        private final WriteConcern m_write;
        private final ReadPreference m_prefs;
        private final CodecRegistry m_codec;

        public MCollectionPreferences(WriteConcern write, ReadPreference prefs, CodecRegistry codec) {
            this.m_write = write;
            this.m_prefs = prefs;
            this.m_codec = codec;
        }

        public MCollectionPreferences(WriteConcern write) {
            this(write, null, null);
        }

        public MCollectionPreferences(ReadPreference prefs) {
            this(null, prefs, null);
        }

        public MCollectionPreferences(CodecRegistry codec) {
            this(null, null, codec);
        }

        public MCollectionPreferences(WriteConcern write, ReadPreference prefs) {
            this(write, prefs, null);
        }

        public MCollectionPreferences(WriteConcern write, CodecRegistry codec) {
            this(write, null, codec);
        }

        public MCollectionPreferences(ReadPreference prefs, CodecRegistry codec) {
            this(null, prefs, codec);
        }

        final boolean isValid() {
            return false == (null == this.m_write && null == this.m_prefs && null == this.m_codec);
        }

        final MCollection withCollectionOptions(MongoCollection<Document> collection, boolean id) {
            return new MCollection(MCollectionPreferences.withCodecRegistry(MCollectionPreferences.withReadPreference(MCollectionPreferences.withWriteConcern(collection, this.m_write), this.m_prefs), this.m_codec), id);
        }

        private static final MongoCollection<Document> withWriteConcern(MongoCollection<Document> collection, WriteConcern write) {
            if (null == write) {
                return collection;
            }
            return collection.withWriteConcern(write);
        }

        private static final MongoCollection<Document> withReadPreference(MongoCollection<Document> collection, ReadPreference prefs) {
            if (null == prefs) {
                return collection;
            }
            return collection.withReadPreference(prefs);
        }

        private static final MongoCollection<Document> withCodecRegistry(MongoCollection<Document> collection, CodecRegistry codec) {
            if (null == codec) {
                return collection;
            }
            return collection.withCodecRegistry(codec);
        }
    }

    public static final class MDatabase {
        private final MongoDatabase m_db;
        private final IMongoDBOptions m_op;
        private final boolean m_id;

        protected MDatabase(MongoDatabase db, boolean id, IMongoDBOptions op) throws Exception {
            this.m_id = id;
            this.m_op = op;
            this.m_db = Objects.requireNonNull(db);
        }

        public boolean isCreateID() {
            return this.m_id;
        }

        public final String getName() {
            return this.m_db.getName();
        }

        public final void drop() {
            this.m_db.drop();
        }

        public final boolean isCollection(String name) {
            return this.getCollectionNames().contains(StringOps.requireTrimOrNull((String)name));
        }

        public final List<String> getCollectionNames() {
            return (List)this.m_db.listCollectionNames().into(new ArrayList());
        }

        public final MCollection collection(String name) throws Exception {
            IMongoDBCollectionOptions cops;
            name = StringOps.requireTrimOrNull((String)name);
            if (null != this.m_op && null != (cops = this.m_op.getCollectionOptions(name))) {
                return new MCollection((MongoCollection<Document>)this.m_db.getCollection(name), cops.isCreateID());
            }
            return new MCollection((MongoCollection<Document>)this.m_db.getCollection(name), this.isCreateID());
        }

        public final MCollection collection(String name, MCollectionPreferences opts) throws Exception {
            name = StringOps.requireTrimOrNull((String)name);
            boolean crid = this.isCreateID();
            if (null != this.m_op) {
                IMongoDBCollectionOptions cops = this.m_op.getCollectionOptions(name);
                if (null != cops) {
                    crid = cops.isCreateID();
                }
                if (null != opts && opts.isValid()) {
                    return opts.withCollectionOptions((MongoCollection<Document>)this.m_db.getCollection(name), crid);
                }
            }
            return new MCollection((MongoCollection<Document>)this.m_db.getCollection(name), crid);
        }
    }
}

