/*
 * Decompiled with CFR 0.152.
 */
package com.ait.tooling.server.mongodb.support.spring;

import com.ait.tooling.common.api.java.util.StringOps;
import com.ait.tooling.common.api.types.Activatable;
import com.ait.tooling.server.core.support.spring.IPropertiesResolver;
import com.ait.tooling.server.core.support.spring.ServerContextInstance;
import com.ait.tooling.server.mongodb.MongoDB;
import com.ait.tooling.server.mongodb.support.spring.IMongoDBCollectionOptions;
import com.ait.tooling.server.mongodb.support.spring.IMongoDBDescriptor;
import com.ait.tooling.server.mongodb.support.spring.IMongoDBOptions;
import com.ait.tooling.server.mongodb.support.spring.MongoDBCollectionOptions;
import com.ait.tooling.server.mongodb.support.spring.MongoDBContextInstance;
import com.ait.tooling.server.mongodb.support.spring.MongoDBOptions;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;

public class MongoDBDescriptor
extends Activatable
implements IMongoDBDescriptor {
    private static final Logger logger = Logger.getLogger(MongoDBDescriptor.class);
    private String m_name;
    private MongoDB m_mongo_db;
    private boolean m_createid = false;
    private boolean m_replicas = false;
    private int m_poolsize = 100;
    private int m_multiple = 100;
    private int m_ctimeout = 10000;
    private String m_defaultd;
    private MongoClientOptions m_coptions;
    private ArrayList<ServerAddress> m_addrlist;
    private ArrayList<MongoCredential> m_authlist;
    private LinkedHashMap<String, IMongoDBOptions> m_doptions;
    private String m_baseprop;

    public MongoDBDescriptor() {
        this.m_baseprop = null;
    }

    public MongoDBDescriptor(String baseprop) {
        this.m_baseprop = StringOps.requireTrimOrNull((String)baseprop);
    }

    public boolean setActive(boolean active) {
        if (null == this.m_addrlist && !this.init()) {
            return false;
        }
        return super.setActive(active);
    }

    private final boolean init() {
        try {
            if (null == this.m_baseprop) {
                this.m_baseprop = MongoDBContextInstance.getMongoDBContextInstance().getMongoDBProvider().getMongoDBDefaultPropertiesBase();
            }
            IPropertiesResolver prop = ServerContextInstance.getServerContextInstance().getPropertiesResolver();
            this.setName(prop.getPropertyByName(this.m_baseprop + ".name"));
            this.setDefaultDB(prop.getPropertyByName(this.m_baseprop + ".db"));
            this.setReplicas(Boolean.valueOf(prop.getPropertyByName(this.m_baseprop + ".replicas", "false")));
            this.setCreateID(Boolean.valueOf(prop.getPropertyByName(this.m_baseprop + ".createid", "false")));
            ArrayList<ServerAddress> addrlist = new ArrayList<ServerAddress>();
            for (String name : StringOps.requireTrimOrNull((String)prop.getPropertyByName(this.m_baseprop + ".host.list")).split(",")) {
                if (null == (name = StringOps.toTrimOrNull((String)name))) continue;
                String addr = StringOps.requireTrimOrNull((String)prop.getPropertyByName(this.m_baseprop + ".host." + name + ".addr"));
                String port = StringOps.requireTrimOrNull((String)prop.getPropertyByName(this.m_baseprop + ".host." + name + ".port"));
                addrlist.add(new ServerAddress(addr, Integer.valueOf(port).intValue()));
            }
            if (addrlist.isEmpty()) {
                throw new IllegalArgumentException("no MongoDB server address");
            }
            this.m_addrlist = addrlist;
            this.m_authlist = new ArrayList();
            String temp = StringOps.toTrimOrNull((String)prop.getPropertyByName(this.m_baseprop + ".auth.list"));
            if (null != temp) {
                for (String name : temp.split(",")) {
                    if (null == (name = StringOps.toTrimOrNull((String)name))) continue;
                    String user = StringOps.requireTrimOrNull((String)prop.getPropertyByName(this.m_baseprop + ".auth." + name + ".user"));
                    String pass = StringOps.requireTrimOrNull((String)prop.getPropertyByName(this.m_baseprop + ".auth." + name + ".pass"));
                    String data = StringOps.requireTrimOrNull((String)prop.getPropertyByName(this.m_baseprop + ".auth." + name + ".db"));
                    this.m_authlist.add(MongoCredential.createCredential((String)user, (String)data, (char[])pass.toCharArray()));
                }
            }
            if (null == this.getClientOptions()) {
                this.setClientOptions(MongoClientOptions.builder().connectionsPerHost(this.getConnectionPoolSize()).threadsAllowedToBlockForConnectionMultiplier(this.getConnectionMultiplier()).connectTimeout(this.getConnectionTimeout()).build());
            }
            this.m_doptions = new LinkedHashMap();
            String conf = StringOps.toTrimOrNull((String)prop.getPropertyByName(this.m_baseprop + ".dbconfig.list"));
            if (null != conf) {
                for (String name : conf.split(",")) {
                    String base;
                    String cols;
                    if (null == (name = StringOps.toTrimOrNull((String)name)) || null != this.m_doptions.get(name)) continue;
                    boolean doid = this.isCreateID();
                    ArrayList<IMongoDBCollectionOptions> list = new ArrayList<IMongoDBCollectionOptions>();
                    String dbid = StringOps.toTrimOrNull((String)prop.getPropertyByName(this.m_baseprop + ".dbconfig." + name + ".createid"));
                    if (null != dbid) {
                        doid = Boolean.valueOf(dbid);
                    }
                    if (null != (cols = StringOps.toTrimOrNull((String)prop.getPropertyByName(base = this.m_baseprop + ".dbconfig." + name + ".collections")))) {
                        for (String coln : cols.split(",")) {
                            if (null == (coln = StringOps.toTrimOrNull((String)coln))) continue;
                            String icid = StringOps.toTrimOrNull((String)prop.getPropertyByName(base + "." + coln + ".createid"));
                            if (null != icid) {
                                list.add(new MongoDBCollectionOptions(coln, Boolean.valueOf(icid)));
                                continue;
                            }
                            list.add(new MongoDBCollectionOptions(coln, doid));
                        }
                    }
                    this.m_doptions.put(name, new MongoDBOptions(name, doid, list));
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"error initializing MongoDBDescriptor", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isCreateID() {
        return this.m_createid;
    }

    private final void setCreateID(boolean createid) {
        this.m_createid = createid;
    }

    @Override
    public void close() throws IOException {
        if (null != this.m_mongo_db) {
            this.m_mongo_db.close();
        }
    }

    public String getName() {
        return this.m_name;
    }

    private final void setName(String name) {
        this.m_name = Objects.requireNonNull(StringOps.toTrimOrNull((String)name), "MongoDBDescriptor name is null or empty");
    }

    @Override
    public synchronized MongoDB getMongoDB() {
        if (null == this.m_mongo_db) {
            this.m_mongo_db = new MongoDB(this.getAddresses(), this.getCredentials(), this.getClientOptions(), this.isReplicas(), this.getDefaultDB(), this.isCreateID(), this.getDBOptions());
        }
        return this.m_mongo_db;
    }

    @Override
    public int getConnectionTimeout() {
        return this.m_ctimeout;
    }

    @Override
    public int getConnectionMultiplier() {
        return this.m_multiple;
    }

    @Override
    public int getConnectionPoolSize() {
        return this.m_poolsize;
    }

    public void setConnectionTimeout(int timeout) {
        this.m_ctimeout = Math.max(0, timeout);
    }

    public void setConnectionMultiplier(int multiplier) {
        this.m_multiple = Math.max(0, multiplier);
    }

    public void setConnectionPoolSize(int poolsize) {
        this.m_poolsize = Math.max(1, poolsize);
    }

    @Override
    public String getDefaultDB() {
        return this.m_defaultd;
    }

    public void setDefaultDB(String name) {
        this.m_defaultd = Objects.requireNonNull(StringOps.toTrimOrNull((String)name), "DefaultDB is null or empty");
    }

    @Override
    public List<MongoCredential> getCredentials() {
        return Collections.unmodifiableList(this.m_authlist);
    }

    @Override
    public boolean isReplicas() {
        return this.m_replicas;
    }

    public void setReplicas(boolean replicas) {
        this.m_replicas = replicas;
    }

    @Override
    public List<ServerAddress> getAddresses() {
        return Collections.unmodifiableList(this.m_addrlist);
    }

    public void setClientOptions(MongoClientOptions coptions) {
        this.m_coptions = Objects.requireNonNull(coptions);
    }

    @Override
    public MongoClientOptions getClientOptions() {
        return this.m_coptions;
    }

    @Override
    public Map<String, IMongoDBOptions> getDBOptions() {
        return Collections.unmodifiableMap(this.m_doptions);
    }
}

