/*
 * Decompiled with CFR 0.152.
 */
package com.ait.tooling.server.mongodb.support.spring;

import com.ait.tooling.common.api.java.util.StringOps;
import com.ait.tooling.server.mongodb.support.spring.IMongoDBCollectionOptions;
import com.ait.tooling.server.mongodb.support.spring.IMongoDBOptions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public class MongoDBOptions
implements IMongoDBOptions {
    private final boolean m_icid;
    private final String m_name;
    private final LinkedHashMap<String, IMongoDBCollectionOptions> m_opts = new LinkedHashMap();

    public MongoDBOptions(String name, boolean icid, List<IMongoDBCollectionOptions> list) {
        this.m_icid = icid;
        this.m_name = StringOps.requireTrimOrNull((String)name);
        for (IMongoDBCollectionOptions opts : Objects.requireNonNull(list)) {
            String coll = StringOps.requireTrimOrNull((String)opts.getName());
            if (null != this.m_opts.get(coll)) continue;
            this.m_opts.put(coll, opts);
        }
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public IMongoDBCollectionOptions getCollectionOptions(String name) {
        return this.m_opts.get(StringOps.requireTrimOrNull((String)name));
    }

    @Override
    public boolean isCreateID() {
        return this.m_icid;
    }
}

