/*
 * Decompiled with CFR 0.152.
 */
package com.ait.tooling.server.mongodb.support.spring;

import com.ait.tooling.common.api.java.util.StringOps;
import com.ait.tooling.server.mongodb.support.spring.IMongoDBDescriptor;
import com.ait.tooling.server.mongodb.support.spring.IMongoDBProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class MongoDBProvider
implements BeanFactoryAware,
IMongoDBProvider {
    private static final Logger logger = Logger.getLogger(MongoDBProvider.class);
    private final String m_default_name;
    private final String m_default_base;
    private final LinkedHashMap<String, IMongoDBDescriptor> m_descriptors = new LinkedHashMap();

    public MongoDBProvider(String default_base, String default_name) {
        this.m_default_base = StringOps.requireTrimOrNull((String)default_base);
        this.m_default_name = StringOps.requireTrimOrNull((String)default_name);
    }

    @Override
    public String getMongoDBDefaultPropertiesBase() {
        return this.m_default_base;
    }

    @Override
    public String getMongoDBDefaultDescriptorName() {
        return this.m_default_name;
    }

    @Override
    public IMongoDBDescriptor getMongoDBDescriptor(String name) {
        return this.m_descriptors.get(StringOps.requireTrimOrNull((String)name));
    }

    @Override
    @ManagedAttribute(description="Get IMongoDBDescriptor names.")
    public List<String> getMongoDBDescriptorNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.m_descriptors.keySet()));
    }

    @Override
    public List<IMongoDBDescriptor> getMongoDBDescriptors() {
        return Collections.unmodifiableList(new ArrayList<IMongoDBDescriptor>(this.m_descriptors.values()));
    }

    @Override
    @ManagedOperation(description="Close all MongoDB Descriptors")
    public void close() throws IOException {
        for (IMongoDBDescriptor descriptor : this.m_descriptors.values()) {
            try {
                logger.info((Object)("Closing MongoDB Descriptor " + descriptor.getName()));
                descriptor.close();
            }
            catch (Exception e) {
                logger.error((Object)("Error closing MongoDB Descriptor " + descriptor.getName()), (Throwable)e);
            }
        }
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        if (factory instanceof DefaultListableBeanFactory) {
            for (IMongoDBDescriptor descriptor : ((DefaultListableBeanFactory)factory).getBeansOfType(IMongoDBDescriptor.class).values()) {
                descriptor.setActive(true);
                String name = StringOps.requireTrimOrNull((String)descriptor.getName());
                if (null == this.m_descriptors.get(name)) {
                    logger.info((Object)("Adding IMongoDBDescriptor(" + name + ") class " + descriptor.getClass().getName()));
                    this.m_descriptors.put(name, descriptor);
                    continue;
                }
                logger.error((Object)("Duplicate IMongoDBDescriptor(" + name + ") class " + descriptor.getClass().getName()));
            }
        }
    }
}

