/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import android.support.v7.util.DiffUtil;
import android.support.v7.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyAdapter;
import com.airbnb.epoxy.ModelState;
import com.airbnb.epoxy.UpdateOp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DiffHelper {
    private static final boolean USE_DIFF_UTIL = false;
    private ArrayList<ModelState> oldStateList = new ArrayList();
    private Map<Long, ModelState> oldStateMap = new HashMap<Long, ModelState>();
    private ArrayList<ModelState> currentStateList = new ArrayList();
    private Map<Long, ModelState> currentStateMap = new HashMap<Long, ModelState>();
    private final EpoxyAdapter adapter;
    private final RecyclerView.AdapterDataObserver observer = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            DiffHelper.this.buildCurrentState();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            for (int i = positionStart; i < positionStart + itemCount; ++i) {
                ((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).hashCode = ((DiffHelper)DiffHelper.this).adapter.models.get(i).hashCode();
            }
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            int i;
            if (itemCount == 0) {
                return;
            }
            if (itemCount == 1 || positionStart == DiffHelper.this.currentStateList.size()) {
                for (int i2 = positionStart; i2 < positionStart + itemCount; ++i2) {
                    DiffHelper.this.currentStateList.add(i2, DiffHelper.this.createStateForPosition(i2));
                }
            } else {
                ArrayList<ModelState> newModels = new ArrayList<ModelState>(itemCount);
                for (i = positionStart; i < positionStart + itemCount; ++i) {
                    newModels.add(DiffHelper.this.createStateForPosition(i));
                }
                DiffHelper.this.currentStateList.addAll(positionStart, newModels);
            }
            int size = DiffHelper.this.currentStateList.size();
            for (i = positionStart + itemCount; i < size; ++i) {
                ((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).position += itemCount;
            }
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            if (itemCount == 0) {
                return;
            }
            List modelsToRemove = DiffHelper.this.currentStateList.subList(positionStart, positionStart + itemCount);
            for (ModelState model : modelsToRemove) {
                DiffHelper.this.currentStateMap.remove(model.id);
                ModelState.release(model);
            }
            modelsToRemove.clear();
            int size = DiffHelper.this.currentStateList.size();
            for (int i = positionStart; i < size; ++i) {
                ((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).position -= itemCount;
            }
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            if (fromPosition == toPosition) {
                return;
            }
            if (itemCount != 1) {
                throw new IllegalArgumentException("Moving more than 1 item at a time is not supported. Number of items moved: " + itemCount);
            }
            ModelState model = (ModelState)DiffHelper.this.currentStateList.remove(fromPosition);
            model.position = toPosition;
            DiffHelper.this.currentStateList.add(toPosition, model);
            if (fromPosition < toPosition) {
                for (int i = fromPosition; i < toPosition; ++i) {
                    --((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).position;
                }
            } else {
                for (int i = toPosition + 1; i <= fromPosition; ++i) {
                    ++((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).position;
                }
            }
        }
    };
    private final DiffUtil.Callback diffUtilCallback = new DiffUtil.Callback(){

        public int getOldListSize() {
            return DiffHelper.this.oldStateList.size();
        }

        public int getNewListSize() {
            return DiffHelper.this.currentStateList.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            return ((ModelState)((DiffHelper)DiffHelper.this).oldStateList.get((int)oldItemPosition)).id == ((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)newItemPosition)).id;
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            return ((ModelState)((DiffHelper)DiffHelper.this).oldStateList.get((int)oldItemPosition)).hashCode == ((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)newItemPosition)).hashCode;
        }
    };

    DiffHelper(EpoxyAdapter adapter) {
        this.adapter = adapter;
        adapter.registerAdapterDataObserver(this.observer);
    }

    public void notifyModelChanges() {
        this.swapCurrentStateToOld();
        this.buildCurrentState();
        Object diffUtilResult = null;
        List<UpdateOp> diff = null;
        diff = this.buildDiff();
        this.adapter.unregisterAdapterDataObserver(this.observer);
        this.notifyChanges(diff);
        UpdateOp.release(diff);
        this.adapter.registerAdapterDataObserver(this.observer);
    }

    private void notifyChanges(List<UpdateOp> diff) {
        block6: for (UpdateOp op : diff) {
            switch (op.type) {
                case 0: {
                    this.adapter.notifyItemRangeInserted(op.positionStart, op.itemCount);
                    continue block6;
                }
                case 3: {
                    this.adapter.notifyItemMoved(op.positionStart, op.itemCount);
                    continue block6;
                }
                case 1: {
                    this.adapter.notifyItemRangeRemoved(op.positionStart, op.itemCount);
                    continue block6;
                }
                case 2: {
                    this.adapter.notifyItemRangeChanged(op.positionStart, op.itemCount);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown type: " + op.type);
        }
    }

    private void buildCurrentState() {
        int size = this.adapter.models.size();
        ModelState.release(this.currentStateList);
        this.currentStateList.clear();
        this.currentStateList.ensureCapacity(size);
        this.currentStateMap.clear();
        for (int i = 0; i < size; ++i) {
            this.currentStateList.add(this.createStateForPosition(i));
        }
    }

    private ModelState createStateForPosition(int position) {
        ModelState state = ModelState.build(this.adapter.models.get(position), position);
        ModelState previousValue = this.currentStateMap.put(state.id, state);
        if (previousValue != null) {
            throw new IllegalStateException("Duplicate ID for model: " + state + " Original: " + previousValue);
        }
        return state;
    }

    private void swapCurrentStateToOld() {
        ArrayList<ModelState> tempList = this.oldStateList;
        this.oldStateList = this.currentStateList;
        this.currentStateList = tempList;
        Map<Long, ModelState> tempMap = this.oldStateMap;
        this.oldStateMap = this.currentStateMap;
        this.currentStateMap = tempMap;
    }

    private List<UpdateOp> buildDiff() {
        boolean hasInsertions;
        ArrayList<UpdateOp> result = new ArrayList<UpdateOp>();
        int removalCount = this.collectRemovals(result);
        boolean bl = hasInsertions = this.oldStateList.size() - removalCount != this.currentStateList.size();
        if (hasInsertions) {
            this.collectInsertions(result);
        }
        this.collectMoves(result);
        this.collectChanges(result);
        return result;
    }

    private int collectRemovals(List<UpdateOp> result) {
        int removalCount = 0;
        UpdateOp lastRemoval = null;
        for (ModelState state : this.oldStateList) {
            state.position -= removalCount;
            state.pair = this.currentStateMap.get(state.id);
            if (state.pair != null) {
                state.pair.pair = state;
                continue;
            }
            int indexToRemove = state.position;
            if (lastRemoval != null && lastRemoval.positionStart == indexToRemove) {
                ++lastRemoval.itemCount;
            } else {
                if (lastRemoval != null) {
                    result.add(lastRemoval);
                }
                lastRemoval = UpdateOp.instance(1, indexToRemove);
            }
            ++removalCount;
        }
        if (lastRemoval != null) {
            result.add(lastRemoval);
        }
        return removalCount;
    }

    private void collectInsertions(List<UpdateOp> result) {
        UpdateOp lastInsertion = null;
        int insertionCount = 0;
        Iterator<ModelState> oldItemIterator = this.oldStateList.iterator();
        for (ModelState itemToInsert : this.currentStateList) {
            if (itemToInsert.pair != null) {
                ModelState nextOldItem = this.getNextItemWithPair(oldItemIterator);
                if (nextOldItem == null) continue;
                nextOldItem.position += insertionCount;
                continue;
            }
            if (lastInsertion != null && lastInsertion.positionStart + lastInsertion.itemCount == itemToInsert.position) {
                ++lastInsertion.itemCount;
            } else {
                if (lastInsertion != null) {
                    result.add(lastInsertion);
                }
                lastInsertion = UpdateOp.instance(0, itemToInsert.position);
            }
            ++insertionCount;
        }
        if (lastInsertion != null) {
            result.add(lastInsertion);
        }
    }

    private void collectChanges(List<UpdateOp> result) {
        UpdateOp lastUpdateOp = null;
        for (ModelState newItem : this.currentStateList) {
            if (newItem.pair == null || newItem.pair.hashCode == newItem.hashCode) continue;
            if (lastUpdateOp != null && lastUpdateOp.positionStart + lastUpdateOp.itemCount == newItem.position) {
                ++lastUpdateOp.itemCount;
                continue;
            }
            if (lastUpdateOp != null) {
                result.add(lastUpdateOp);
            }
            lastUpdateOp = UpdateOp.instance(2, newItem.position);
        }
        if (lastUpdateOp != null) {
            result.add(lastUpdateOp);
        }
    }

    private void collectMoves(List<UpdateOp> result) {
        Iterator<ModelState> oldItemIterator = this.oldStateList.iterator();
        ModelState nextOldItem = null;
        ArrayList<UpdateOp> moveOps = new ArrayList<UpdateOp>();
        block0: for (ModelState newItem : this.currentStateList) {
            if (newItem.pair == null) {
                if (moveOps.isEmpty()) continue;
                newItem.pairWithSelf();
            }
            if (nextOldItem == null && (nextOldItem = this.getNextItemWithPair(oldItemIterator)) == null) {
                nextOldItem = newItem.pair;
            }
            while (nextOldItem != null) {
                UpdateOp moveOp;
                this.updateItemPosition(newItem.pair, moveOps);
                this.updateItemPosition(nextOldItem, moveOps);
                if (newItem.id == nextOldItem.id && newItem.position == nextOldItem.position) {
                    nextOldItem = null;
                    continue block0;
                }
                int newItemDistance = newItem.pair.position - newItem.position;
                int oldItemDistance = nextOldItem.pair.position - nextOldItem.position;
                if (newItemDistance == 0 && oldItemDistance == 0) {
                    nextOldItem = null;
                    continue block0;
                }
                if (oldItemDistance > newItemDistance) {
                    moveOp = UpdateOp.instance(3, nextOldItem.position, nextOldItem.pair.position);
                    result.add(moveOp);
                    moveOps.add(moveOp);
                    nextOldItem.position = nextOldItem.pair.position;
                    nextOldItem.lastMoveOp = moveOps.size();
                    nextOldItem = this.getNextItemWithPair(oldItemIterator);
                    continue;
                }
                moveOp = UpdateOp.instance(3, newItem.pair.position, newItem.position);
                result.add(moveOp);
                moveOps.add(moveOp);
                newItem.pair.position = newItem.position;
                newItem.pair.lastMoveOp = moveOps.size();
                continue block0;
            }
        }
    }

    private void updateItemPosition(ModelState item, List<UpdateOp> moveOps) {
        int size = moveOps.size();
        for (int i = item.lastMoveOp; i < size; ++i) {
            UpdateOp moveOp = moveOps.get(i);
            int fromPosition = moveOp.positionStart;
            int toPosition = moveOp.itemCount;
            if (item.position > fromPosition && item.position <= toPosition) {
                --item.position;
                continue;
            }
            if (item.position >= fromPosition || item.position < toPosition) continue;
            ++item.position;
        }
        item.lastMoveOp = size;
    }

    @Nullable
    private ModelState getNextItemWithPair(Iterator<ModelState> iterator) {
        ModelState nextItem = null;
        while (nextItem == null && iterator.hasNext()) {
            nextItem = iterator.next();
            if (nextItem.pair != null) continue;
            nextItem = null;
        }
        return nextItem;
    }
}

