/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.airbnb.epoxy.EpoxyModel;
import java.util.List;

public class EpoxyViewHolder
extends RecyclerView.ViewHolder {
    private EpoxyModel epoxyModel;
    private List<Object> payloads;

    public EpoxyViewHolder(ViewGroup parent, @LayoutRes int layoutId) {
        super(LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false));
    }

    public void bind(EpoxyModel model, List<Object> payloads) {
        this.payloads = payloads;
        if (payloads.isEmpty()) {
            model.bind((Object)this.itemView);
        } else {
            model.bind((Object)this.itemView, payloads);
        }
        this.epoxyModel = model;
    }

    public void unbind() {
        this.assertBound();
        this.epoxyModel.unbind((Object)this.itemView);
        this.epoxyModel = null;
        this.payloads = null;
    }

    public List<Object> getPayloads() {
        this.assertBound();
        return this.payloads;
    }

    public EpoxyModel<?> getModel() {
        this.assertBound();
        return this.epoxyModel;
    }

    private void assertBound() {
        if (this.epoxyModel == null) {
            throw new IllegalStateException("This holder is not currently bound.");
        }
    }

    public String toString() {
        return "EpoxyViewHolder{epoxyModel=" + this.epoxyModel + ", view=" + this.itemView + ", super=" + super.toString() + '}';
    }
}

