/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.v4.util.Pools;
import com.airbnb.epoxy.EpoxyModel;
import java.util.Collection;

class ModelState {
    private static final Pools.Pool<ModelState> POOL = new Pools.SimplePool(200);
    long id;
    int hashCode;
    int position;
    ModelState pair;
    int lastMoveOp;

    ModelState() {
    }

    static ModelState build(EpoxyModel<?> model, int position) {
        ModelState state = ModelState.get();
        state.lastMoveOp = 0;
        state.pair = null;
        state.id = model.id();
        state.hashCode = model.hashCode();
        state.position = position;
        return state;
    }

    private static ModelState get() {
        ModelState state = (ModelState)POOL.acquire();
        if (state == null) {
            state = new ModelState();
        }
        return state;
    }

    public void pairWithSelf() {
        if (this.pair != null) {
            throw new IllegalStateException("Already paired.");
        }
        this.pair = ModelState.get();
        this.pair.lastMoveOp = 0;
        this.pair.id = this.id;
        this.pair.position = this.position;
        this.pair.hashCode = this.hashCode;
        this.pair.pair = this;
    }

    static void release(Collection<ModelState> states) {
        for (ModelState state : states) {
            ModelState.release(state);
        }
    }

    public static void release(ModelState state) {
        POOL.release((Object)state);
    }

    public String toString() {
        return "ModelState{id=" + this.id + ", hashCode=" + this.hashCode + ", position=" + this.position + ", pair=" + this.pair + ", lastMoveOp=" + this.lastMoveOp + '}';
    }
}

