/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.v4.util.Pools;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

class UpdateOp {
    private static final Pools.Pool<UpdateOp> UPDATE_OP_POOL = new Pools.SimplePool(10);
    static final int ADD = 0;
    static final int REMOVE = 1;
    static final int UPDATE = 2;
    static final int MOVE = 3;
    int type;
    int positionStart;
    int itemCount;

    private UpdateOp() {
    }

    static UpdateOp instance(int type, int positionStart, int itemCount) {
        UpdateOp op = (UpdateOp)UPDATE_OP_POOL.acquire();
        if (op == null) {
            op = new UpdateOp();
        }
        op.type = type;
        op.positionStart = positionStart;
        op.itemCount = itemCount;
        return op;
    }

    static UpdateOp instance(int type, int positionStart) {
        return UpdateOp.instance(type, positionStart, 1);
    }

    static void release(List<UpdateOp> diff) {
        for (UpdateOp updateOp : diff) {
            UPDATE_OP_POOL.release((Object)updateOp);
        }
    }

    public String toString() {
        return "UpdateOp{type=" + this.type + ", positionStart=" + this.positionStart + ", itemCount=" + this.itemCount + '}';
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Type {
    }
}

