/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.view.View;
import com.airbnb.epoxy.EpoxyModel;

public class SimpleEpoxyModel
extends EpoxyModel<View> {
    @LayoutRes
    private final int layoutRes;
    private View.OnClickListener onClickListener;
    private int spanCount = 1;

    public SimpleEpoxyModel(@LayoutRes int layoutRes) {
        this.layoutRes = layoutRes;
    }

    public SimpleEpoxyModel onClick(View.OnClickListener listener) {
        this.onClickListener = listener;
        return this;
    }

    public SimpleEpoxyModel span(int span) {
        this.spanCount = span;
        return this;
    }

    @CallSuper
    public void bind(View view) {
        super.bind((Object)view);
        view.setOnClickListener(this.onClickListener);
        view.setClickable(this.onClickListener != null);
    }

    @CallSuper
    public void unbind(View view) {
        super.unbind((Object)view);
        view.setOnClickListener(null);
    }

    protected int getDefaultLayout() {
        return this.layoutRes;
    }

    public int getSpanSize(int totalSpanCount, int position, int itemCount) {
        return this.spanCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleEpoxyModel)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleEpoxyModel that = (SimpleEpoxyModel)((Object)o);
        if (this.layoutRes != that.layoutRes) {
            return false;
        }
        if (this.spanCount != that.spanCount) {
            return false;
        }
        return this.onClickListener != null ? this.onClickListener.equals(that.onClickListener) : that.onClickListener == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.layoutRes;
        result = 31 * result + (this.onClickListener != null ? this.onClickListener.hashCode() : 0);
        result = 31 * result + this.spanCount;
        return result;
    }
}

