/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.LayoutRes;
import java.util.List;

public abstract class EpoxyModel<T> {
    private static long idCounter = -1L;
    private long id;
    @LayoutRes
    private int layout;
    private boolean shown = true;
    boolean addedToAdapter;

    protected EpoxyModel(long id) {
        this.id(id);
    }

    public EpoxyModel() {
        this(idCounter--);
    }

    public void bind(T view) {
    }

    public void bind(T view, List<Object> payloads) {
        this.bind(view);
    }

    public void unbind(T view) {
    }

    public long id() {
        return this.id;
    }

    public EpoxyModel<T> id(long id) {
        if (this.addedToAdapter && id != this.id) {
            throw new IllegalStateException("Cannot change a model's id after it has been added to the adapter.");
        }
        this.id = id;
        return this;
    }

    public EpoxyModel<T> id(CharSequence key) {
        this.id(EpoxyModel.hashString64Bit(key));
        return this;
    }

    public EpoxyModel<T> id(CharSequence key, long id) {
        long result = EpoxyModel.hashString64Bit(key);
        result = 31L * result + EpoxyModel.hashLong64Bit(id);
        this.id(result);
        return this;
    }

    private static long hashLong64Bit(long value) {
        value ^= value << 21;
        value ^= value >>> 35;
        value ^= value << 4;
        return value;
    }

    private static long hashString64Bit(CharSequence str) {
        long result = -3750763034362895579L;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            result ^= (long)str.charAt(i);
            result *= 1099511628211L;
        }
        return result;
    }

    @LayoutRes
    protected abstract int getDefaultLayout();

    public EpoxyModel<T> layout(@LayoutRes int layoutRes) {
        this.layout = layoutRes;
        return this;
    }

    @LayoutRes
    public final int getLayout() {
        if (this.layout == 0) {
            return this.getDefaultLayout();
        }
        return this.layout;
    }

    public EpoxyModel<T> reset() {
        this.layout = 0;
        this.shown = true;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EpoxyModel)) {
            return false;
        }
        EpoxyModel that = (EpoxyModel)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.getLayout() != that.getLayout()) {
            return false;
        }
        return this.shown == that.shown;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.getLayout();
        result = 31 * result + (this.shown ? 1 : 0);
        return result;
    }

    public int getSpanSize(int totalSpanCount, int position, int itemCount) {
        return 1;
    }

    public EpoxyModel<T> show() {
        this.shown = true;
        return this;
    }

    public EpoxyModel<T> show(boolean show) {
        this.shown = show;
        return this;
    }

    public EpoxyModel<T> hide() {
        this.shown = false;
        return this;
    }

    public boolean isShown() {
        return this.shown;
    }

    public boolean shouldSaveViewState() {
        return false;
    }

    public boolean onFailedToRecycleView(T view) {
        return false;
    }

    public void onViewAttachedToWindow(T view) {
    }

    public void onViewDetachedFromWindow(T view) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id=" + this.id + ", layout=" + this.getLayout() + ", shown=" + this.shown + ", addedToAdapter=" + this.addedToAdapter + '}';
    }
}

