/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.airbnb.epoxy.BoundViewHolders;
import com.airbnb.epoxy.DiffHelper;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.HiddenEpoxyModel;
import com.airbnb.epoxy.ModelList;
import com.airbnb.epoxy.ViewHolderState;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class EpoxyAdapter
extends RecyclerView.Adapter<EpoxyViewHolder> {
    private static final String SAVED_STATE_ARG_VIEW_HOLDERS = "saved_state_view_holders";
    protected final List<EpoxyModel<?>> models = new ModelList();
    private int spanCount = 1;
    private final HiddenEpoxyModel hiddenModel = new HiddenEpoxyModel();
    private final BoundViewHolders boundViewHolders = new BoundViewHolders();
    private ViewHolderState viewHolderState = new ViewHolderState();
    private DiffHelper diffHelper;
    private final GridLayoutManager.SpanSizeLookup spanSizeLookup = new GridLayoutManager.SpanSizeLookup(){

        public int getSpanSize(int position) {
            try {
                return EpoxyAdapter.this.getModelForPosition(position).getSpanSize(EpoxyAdapter.this.spanCount, position, EpoxyAdapter.this.getItemCount());
            }
            catch (IndexOutOfBoundsException e) {
                return 1;
            }
        }
    };

    public EpoxyAdapter() {
        this.setHasStableIds(true);
        this.spanSizeLookup.setSpanIndexCacheEnabled(true);
    }

    protected void enableDiffing() {
        if (this.diffHelper != null) {
            throw new IllegalStateException("Diffing was already enabled");
        }
        if (!this.models.isEmpty()) {
            throw new IllegalStateException("You must enable diffing before modifying models");
        }
        if (!this.hasStableIds()) {
            throw new IllegalStateException("You must have stable ids to use diffing");
        }
        this.diffHelper = new DiffHelper(this);
    }

    protected void notifyModelsChanged() {
        if (this.diffHelper == null) {
            throw new IllegalStateException("You must enable diffing before notifying models changed");
        }
        this.diffHelper.notifyModelChanges();
    }

    public int getItemCount() {
        return this.models.size();
    }

    public boolean isEmpty() {
        return this.models.isEmpty();
    }

    public EpoxyViewHolder onCreateViewHolder(ViewGroup parent, int layoutRes) {
        return new EpoxyViewHolder(parent, layoutRes);
    }

    public void onBindViewHolder(EpoxyViewHolder holder, int position) {
        this.onBindViewHolder(holder, position, Collections.emptyList());
    }

    public void onBindViewHolder(EpoxyViewHolder holder, int position, List<Object> payloads) {
        EpoxyViewHolder boundViewHolder = this.boundViewHolders.get(holder);
        if (boundViewHolder != null) {
            this.viewHolderState.save(boundViewHolder);
        }
        EpoxyModel<?> modelToShow = this.getModelForPosition(position);
        holder.bind(modelToShow, payloads);
        this.viewHolderState.restore(holder);
        this.boundViewHolders.put(holder);
        this.onModelBound(holder, modelToShow, position, payloads);
    }

    protected void onModelBound(EpoxyViewHolder holder, EpoxyModel<?> model, int position, @Nullable List<Object> payloads) {
        this.onModelBound(holder, model, position);
    }

    protected void onModelBound(EpoxyViewHolder holder, EpoxyModel<?> model, int position) {
    }

    protected BoundViewHolders getBoundViewHolders() {
        return this.boundViewHolders;
    }

    public int getItemViewType(int position) {
        return this.getModelForPosition(position).getLayout();
    }

    public long getItemId(int position) {
        return this.models.get(position).id();
    }

    private EpoxyModel<?> getModelForPosition(int position) {
        HiddenEpoxyModel epoxyModel = this.models.get(position);
        return epoxyModel.isShown() ? epoxyModel : this.hiddenModel;
    }

    public void onViewRecycled(EpoxyViewHolder holder) {
        this.viewHolderState.save(holder);
        this.boundViewHolders.remove(holder);
        EpoxyModel<?> model = holder.getModel();
        holder.unbind();
        this.onModelUnbound(holder, model);
    }

    protected void onModelUnbound(EpoxyViewHolder holder, EpoxyModel<?> model) {
    }

    @CallSuper
    public boolean onFailedToRecycleView(EpoxyViewHolder holder) {
        return holder.getModel().onFailedToRecycleView(holder.objectToBind());
    }

    @CallSuper
    public void onViewAttachedToWindow(EpoxyViewHolder holder) {
        holder.getModel().onViewAttachedToWindow(holder.objectToBind());
    }

    @CallSuper
    public void onViewDetachedFromWindow(EpoxyViewHolder holder) {
        holder.getModel().onViewDetachedFromWindow(holder.objectToBind());
    }

    public void onSaveInstanceState(Bundle outState) {
        for (EpoxyViewHolder holder : this.boundViewHolders) {
            this.viewHolderState.save(holder);
        }
        if (this.viewHolderState.size() > 0 && !this.hasStableIds()) {
            throw new IllegalStateException("Must have stable ids when saving view holder state");
        }
        outState.putParcelable(SAVED_STATE_ARG_VIEW_HOLDERS, (Parcelable)this.viewHolderState);
    }

    public void onRestoreInstanceState(@Nullable Bundle inState) {
        if (this.boundViewHolders.size() > 0) {
            throw new IllegalStateException("State cannot be restored once views have been bound. It should be done before adding the adapter to the recycler view.");
        }
        if (inState != null) {
            this.viewHolderState = (ViewHolderState)inState.getParcelable(SAVED_STATE_ARG_VIEW_HOLDERS);
        }
    }

    protected void notifyModelChanged(EpoxyModel<?> model) {
        this.notifyModelChanged(model, null);
    }

    protected void notifyModelChanged(EpoxyModel<?> model, @Nullable Object payload) {
        int index = this.getModelPosition(model);
        if (index != -1) {
            this.notifyItemChanged(index, payload);
        }
    }

    protected void addModel(EpoxyModel<?> modelToAdd) {
        int initialSize = this.models.size();
        this.pauseModelListNotifications();
        this.models.add(modelToAdd);
        this.resumeModelListNotifications();
        this.notifyItemRangeInserted(initialSize, 1);
    }

    protected void addModels(EpoxyModel<?> ... modelsToAdd) {
        int initialSize = this.models.size();
        int numModelsToAdd = modelsToAdd.length;
        ((ModelList)this.models).ensureCapacity(initialSize + numModelsToAdd);
        this.pauseModelListNotifications();
        Collections.addAll(this.models, modelsToAdd);
        this.resumeModelListNotifications();
        this.notifyItemRangeInserted(initialSize, numModelsToAdd);
    }

    protected void addModels(Collection<? extends EpoxyModel<?>> modelsToAdd) {
        int initialSize = this.models.size();
        this.pauseModelListNotifications();
        this.models.addAll(modelsToAdd);
        this.resumeModelListNotifications();
        this.notifyItemRangeInserted(initialSize, modelsToAdd.size());
    }

    protected void insertModelBefore(EpoxyModel<?> modelToInsert, EpoxyModel<?> modelToInsertBefore) {
        int targetIndex = this.getModelPosition(modelToInsertBefore);
        if (targetIndex == -1) {
            throw new IllegalStateException("Model is not added: " + modelToInsertBefore);
        }
        this.pauseModelListNotifications();
        this.models.add(targetIndex, modelToInsert);
        this.resumeModelListNotifications();
        this.notifyItemInserted(targetIndex);
    }

    protected void insertModelAfter(EpoxyModel<?> modelToInsert, EpoxyModel<?> modelToInsertAfter) {
        int modelIndex = this.getModelPosition(modelToInsertAfter);
        if (modelIndex == -1) {
            throw new IllegalStateException("Model is not added: " + modelToInsertAfter);
        }
        int targetIndex = modelIndex + 1;
        this.pauseModelListNotifications();
        this.models.add(targetIndex, modelToInsert);
        this.resumeModelListNotifications();
        this.notifyItemInserted(targetIndex);
    }

    protected void removeModel(EpoxyModel<?> model) {
        int index = this.getModelPosition(model);
        if (index != -1) {
            this.pauseModelListNotifications();
            this.models.remove(index);
            this.resumeModelListNotifications();
            this.notifyItemRemoved(index);
        }
    }

    protected void removeAllModels() {
        int numModelsRemoved = this.models.size();
        this.pauseModelListNotifications();
        this.models.clear();
        this.resumeModelListNotifications();
        this.notifyItemRangeRemoved(0, numModelsRemoved);
    }

    protected void removeAllAfterModel(EpoxyModel<?> model) {
        List<EpoxyModel<?>> modelsToRemove = this.getAllModelsAfter(model);
        int numModelsRemoved = modelsToRemove.size();
        int initialModelCount = this.models.size();
        this.pauseModelListNotifications();
        modelsToRemove.clear();
        this.resumeModelListNotifications();
        this.notifyItemRangeRemoved(initialModelCount - numModelsRemoved, numModelsRemoved);
    }

    protected void showModel(EpoxyModel<?> model, boolean show) {
        if (model.isShown() == show) {
            return;
        }
        model.show(show);
        this.notifyModelChanged(model);
    }

    protected void showModel(EpoxyModel<?> model) {
        this.showModel(model, true);
    }

    protected void showModels(EpoxyModel<?> ... models) {
        this.showModels(Arrays.asList(models));
    }

    protected void showModels(boolean show, EpoxyModel<?> ... models) {
        this.showModels(Arrays.asList(models), show);
    }

    protected void showModels(Iterable<EpoxyModel<?>> models) {
        this.showModels(models, true);
    }

    protected void showModels(Iterable<EpoxyModel<?>> models, boolean show) {
        for (EpoxyModel<?> model : models) {
            this.showModel(model, show);
        }
    }

    protected void hideModel(EpoxyModel<?> model) {
        this.showModel(model, false);
    }

    protected void hideModels(Iterable<EpoxyModel<?>> models) {
        this.showModels(models, false);
    }

    protected void hideModels(EpoxyModel<?> ... models) {
        this.hideModels(Arrays.asList(models));
    }

    protected void hideAllAfterModel(EpoxyModel<?> model) {
        this.hideModels(this.getAllModelsAfter(model));
    }

    protected List<EpoxyModel<?>> getAllModelsAfter(EpoxyModel<?> model) {
        int index = this.getModelPosition(model);
        if (index == -1) {
            throw new IllegalStateException("Model is not added: " + model);
        }
        return this.models.subList(index + 1, this.models.size());
    }

    protected int getModelPosition(EpoxyModel<?> model) {
        int size = this.models.size();
        for (int i = 0; i < size; ++i) {
            if (model != this.models.get(i)) continue;
            return i;
        }
        return -1;
    }

    public GridLayoutManager.SpanSizeLookup getSpanSizeLookup() {
        return this.spanSizeLookup;
    }

    public void setSpanCount(int spanCount) {
        this.spanCount = spanCount;
    }

    public int getSpanCount() {
        return this.spanCount;
    }

    public boolean isMultiSpan() {
        return this.spanCount > 1;
    }

    private void pauseModelListNotifications() {
        ((ModelList)this.models).pauseNotifications();
    }

    private void resumeModelListNotifications() {
        ((ModelList)this.models).resumeNotifications();
    }
}

