/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.UpdateOp;
import java.util.ArrayList;
import java.util.List;

class UpdateOpHelper {
    final List<UpdateOp> opList = new ArrayList<UpdateOp>();
    final List<UpdateOp> moves = new ArrayList<UpdateOp>();
    private UpdateOp lastOp;
    private int numInsertions;
    private int numInsertionBatches;
    private int numRemovals;
    private int numRemovalBatches;

    UpdateOpHelper() {
    }

    void reset() {
        this.opList.clear();
        this.moves.clear();
        this.lastOp = null;
        this.numInsertions = 0;
        this.numInsertionBatches = 0;
        this.numRemovals = 0;
        this.numRemovalBatches = 0;
    }

    void add(int indexToInsert) {
        this.add(indexToInsert, 1);
    }

    void add(int startPosition, int itemCount) {
        boolean batchWithLast;
        this.numInsertions += itemCount;
        boolean bl = batchWithLast = this.isLastOp(0) && (this.lastOp.contains(startPosition) || this.lastOp.positionEnd() == startPosition);
        if (!batchWithLast) {
            ++this.numInsertionBatches;
        }
        this.addOperation(0, startPosition, itemCount, batchWithLast);
    }

    void update(int indexToChange) {
        this.update(indexToChange, 1);
    }

    void update(int startPosition, int itemCount) {
        boolean batchWithLast = false;
        if (this.isLastOp(2)) {
            int lastIndexInRange = startPosition + itemCount - 1;
            if (this.lastOp.contains(startPosition) && this.lastOp.contains(lastIndexInRange)) {
                return;
            }
            if (this.lastOp.isAfter(startPosition) && this.lastOp.isBefore(lastIndexInRange)) {
                itemCount -= this.lastOp.itemCount;
                this.lastOp.positionStart = startPosition;
                batchWithLast = true;
            } else if (this.lastOp.isAfter(startPosition) && lastIndexInRange >= this.lastOp.positionStart - 1) {
                itemCount = this.lastOp.positionStart - startPosition;
                this.lastOp.positionStart = startPosition;
                batchWithLast = true;
            } else if (startPosition <= this.lastOp.positionEnd() && this.lastOp.isBefore(lastIndexInRange)) {
                itemCount -= this.lastOp.positionEnd() - startPosition;
                batchWithLast = true;
            }
        }
        this.addOperation(2, startPosition, itemCount, batchWithLast);
    }

    void remove(int indexToRemove) {
        this.remove(indexToRemove, 1);
    }

    void remove(int startPosition, int itemCount) {
        this.numRemovals += itemCount;
        boolean batchWithLast = false;
        if (this.isLastOp(1)) {
            if (this.lastOp.positionStart == startPosition) {
                batchWithLast = true;
            } else if (this.lastOp.isAfter(startPosition) && startPosition + itemCount >= this.lastOp.positionStart) {
                this.lastOp.positionStart = startPosition;
                batchWithLast = true;
            }
        }
        if (!batchWithLast) {
            ++this.numRemovalBatches;
        }
        this.addOperation(1, startPosition, itemCount, batchWithLast);
    }

    private boolean isLastOp(int updateType) {
        return this.lastOp != null && this.lastOp.type == updateType;
    }

    private void addOperation(int type, int position, int itemCount, boolean batchWithLast) {
        if (batchWithLast) {
            this.lastOp.itemCount += itemCount;
        } else {
            this.lastOp = UpdateOp.instance(type, position, itemCount);
            this.opList.add(this.lastOp);
        }
    }

    void move(int from, int to) {
        this.lastOp = null;
        UpdateOp op = UpdateOp.instance(3, from, to);
        this.opList.add(op);
        this.moves.add(op);
    }

    int getNumRemovals() {
        return this.numRemovals;
    }

    boolean hasRemovals() {
        return this.numRemovals > 0;
    }

    int getNumInsertions() {
        return this.numInsertions;
    }

    boolean hasInsertions() {
        return this.numInsertions > 0;
    }

    int getNumMoves() {
        return this.moves.size();
    }

    int getNumInsertionBatches() {
        return this.numInsertionBatches;
    }

    int getNumRemovalBatches() {
        return this.numRemovalBatches;
    }
}

