/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.NonNull;
import com.airbnb.epoxy.EpoxyModel;

class ImmutableModelException
extends RuntimeException {
    private static final String MODEL_CANNOT_BE_CHANGED_MESSAGE = "A model cannot be changed once it is added to a controller. The only exception is if the change is made inside an Interceptor callback. Consider using an interceptor if you need to change a model after it is added to the controller and before it is set on the adapter. If the model is already set on the adapter then you must call `requestModelBuild` instead to recreate all models.";

    ImmutableModelException(EpoxyModel model, int modelPosition) {
        this(model, "", modelPosition);
    }

    ImmutableModelException(EpoxyModel model, String descriptionOfWhenChangeHappened, int modelPosition) {
        super(ImmutableModelException.buildMessage(model, descriptionOfWhenChangeHappened, modelPosition));
    }

    @NonNull
    private static String buildMessage(EpoxyModel model, String descriptionOfWhenChangeHappened, int modelPosition) {
        return descriptionOfWhenChangeHappened + " Position: " + modelPosition + " Model: " + model.toString() + "\n\n" + MODEL_CANNOT_BE_CHANGED_MESSAGE;
    }
}

