/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import com.airbnb.epoxy.BaseEpoxyAdapter;
import com.airbnb.epoxy.DiffHelper;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.NotifyBlocker;
import com.airbnb.epoxy.UnmodifiableList;
import java.util.Collections;
import java.util.List;

public final class EpoxyControllerAdapter
extends BaseEpoxyAdapter {
    private final DiffHelper diffHelper = new DiffHelper(this, true);
    private final NotifyBlocker notifyBlocker = new NotifyBlocker();
    private final EpoxyController epoxyController;
    private List<EpoxyModel<?>> currentModels = Collections.emptyList();
    private List<EpoxyModel<?>> copyOfCurrentModels;
    private int itemCount;

    EpoxyControllerAdapter(EpoxyController epoxyController) {
        this.epoxyController = epoxyController;
        this.registerAdapterDataObserver(this.notifyBlocker);
    }

    @Override
    protected void onExceptionSwallowed(RuntimeException exception) {
        this.epoxyController.onExceptionSwallowed(exception);
    }

    @Override
    List<EpoxyModel<?>> getCurrentModels() {
        return this.currentModels;
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    void setModels(List<EpoxyModel<?>> models) {
        this.itemCount = models.size();
        this.copyOfCurrentModels = null;
        this.currentModels = models;
        this.notifyBlocker.allowChanges();
        this.diffHelper.notifyModelChanges();
        this.notifyBlocker.blockChanges();
    }

    @Override
    boolean diffPayloadsEnabled() {
        return true;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.epoxyController.onAttachedToRecyclerViewInternal(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.epoxyController.onDetachedFromRecyclerViewInternal(recyclerView);
    }

    @Override
    public void onViewAttachedToWindow(EpoxyViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        this.epoxyController.onViewAttachedToWindow(holder, holder.getModel());
    }

    @Override
    public void onViewDetachedFromWindow(EpoxyViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        this.epoxyController.onViewDetachedFromWindow(holder, holder.getModel());
    }

    @Override
    protected void onModelBound(EpoxyViewHolder holder, EpoxyModel<?> model, int position, @Nullable EpoxyModel<?> previouslyBoundModel) {
        this.epoxyController.onModelBound(holder, model, position, previouslyBoundModel);
    }

    @Override
    protected void onModelUnbound(EpoxyViewHolder holder, EpoxyModel<?> model) {
        this.epoxyController.onModelUnbound(holder, model);
    }

    public List<EpoxyModel<?>> getCopyOfModels() {
        if (this.copyOfCurrentModels == null) {
            this.copyOfCurrentModels = new UnmodifiableList(this.currentModels);
        }
        return this.copyOfCurrentModels;
    }

    public EpoxyModel<?> getModelAtPosition(int position) {
        return this.currentModels.get(position);
    }

    @Nullable
    public EpoxyModel<?> getModelById(long id) {
        for (EpoxyModel<?> model : this.currentModels) {
            if (model.id() != id) continue;
            return model;
        }
        return null;
    }

    @Override
    protected int getModelPosition(EpoxyModel<?> targetModel) {
        int size = this.currentModels.size();
        for (int i = 0; i < size; ++i) {
            EpoxyModel<?> model = this.currentModels.get(i);
            if (model.id() != targetModel.id()) continue;
            return i;
        }
        return -1;
    }
}

