/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.LayoutRes;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import com.airbnb.epoxy.EpoxyHolder;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyModelWithHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class EpoxyModelGroup
extends EpoxyModelWithHolder<Holder> {
    protected final List<? extends EpoxyModel<?>> models;
    private final boolean shouldSaveViewState;

    public EpoxyModelGroup(@LayoutRes int layoutRes, Collection<? extends EpoxyModel<?>> models) {
        this(layoutRes, new ArrayList(models));
    }

    public EpoxyModelGroup(@LayoutRes int layoutRes, EpoxyModel<?> ... models) {
        this(layoutRes, new ArrayList(Arrays.asList(models)));
    }

    private EpoxyModelGroup(@LayoutRes int layoutRes, List<? extends EpoxyModel<?>> models) {
        if (models.isEmpty()) {
            throw new IllegalArgumentException("Models cannot be empty");
        }
        this.models = models;
        this.layout(layoutRes);
        this.id(models.get(0).id());
        boolean saveState = false;
        for (EpoxyModel<?> model : models) {
            if (!model.shouldSaveViewState()) continue;
            saveState = true;
            break;
        }
        this.shouldSaveViewState = saveState;
    }

    @Override
    public final void bind(Holder holder) {
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, Object boundObject, View view) {
                EpoxyModelGroup.setViewVisibility(model, view);
                model.bind(boundObject);
            }
        });
    }

    @Override
    public final void bind(Holder holder, final List<Object> payloads) {
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, Object boundObject, View view) {
                EpoxyModelGroup.setViewVisibility(model, view);
                model.bind(boundObject, payloads);
            }
        });
    }

    private static void setViewVisibility(EpoxyModel model, View view) {
        if (model.isShown()) {
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    @Override
    public final void unbind(Holder holder) {
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, Object boundObject, View view) {
                model.unbind(boundObject);
            }
        });
    }

    @Override
    public void onViewAttachedToWindow(Holder holder) {
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, Object boundObject, View view) {
                model.onViewAttachedToWindow(boundObject);
            }
        });
    }

    @Override
    public void onViewDetachedFromWindow(Holder holder) {
        this.iterateModels(holder, new IterateModelsCallback(){

            @Override
            public void onModel(EpoxyModel model, Object boundObject, View view) {
                model.onViewDetachedFromWindow(boundObject);
            }
        });
    }

    private void iterateModels(Holder holder, IterateModelsCallback callback) {
        int modelCount = this.models.size();
        if (modelCount != holder.views.size()) {
            throw new IllegalStateException("The number of models used in this group has changed. The model count must remain constant if the same layout resource is used. If you need to change which models are shown you can call EpoxyMode#hide() to have a model's view hidden, or use a different layout resource for the group.");
        }
        for (int i = 0; i < modelCount; ++i) {
            EpoxyModel<?> model = this.models.get(i);
            View view = (View)holder.views.get(i);
            EpoxyHolder epoxyHolder = (EpoxyHolder)holder.holders.get(i);
            EpoxyHolder objectToBind = model instanceof EpoxyModelWithHolder ? epoxyHolder : view;
            callback.onModel(model, objectToBind, view);
        }
    }

    @Override
    public int getSpanSize(int totalSpanCount, int position, int itemCount) {
        return this.models.get(0).getSpanSize(totalSpanCount, position, itemCount);
    }

    @Override
    protected final int getDefaultLayout() {
        throw new UnsupportedOperationException("You should set a layout with layout(...) instead of using this.");
    }

    @Override
    public boolean shouldSaveViewState() {
        return this.shouldSaveViewState;
    }

    protected boolean useViewStubLayoutParams(EpoxyModel<?> model, int modelPosition) {
        return true;
    }

    @Override
    protected final Holder createNewHolder() {
        return new Holder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EpoxyModelGroup)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EpoxyModelGroup that = (EpoxyModelGroup)o;
        return this.models.equals(that.models);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.models.hashCode();
        return result;
    }

    private static class ViewStubData {
        private final ViewGroup viewGroup;
        private final ViewStub viewStub;
        private final int position;

        private ViewStubData(ViewGroup viewGroup, ViewStub viewStub, int position) {
            this.viewGroup = viewGroup;
            this.viewStub = viewStub;
            this.position = position;
        }
    }

    protected class Holder
    extends EpoxyHolder {
        private List<View> views;
        private List<EpoxyHolder> holders;

        protected Holder() {
        }

        @Override
        protected void bindView(View itemView) {
            if (!(itemView instanceof ViewGroup)) {
                throw new IllegalStateException("The layout provided to EpoxyModelGroup must be a ViewGroup");
            }
            ViewGroup groupView = (ViewGroup)itemView;
            int modelCount = EpoxyModelGroup.this.models.size();
            this.views = new ArrayList<View>(modelCount);
            this.holders = new ArrayList<EpoxyHolder>(modelCount);
            boolean useViewStubs = groupView.getChildCount() != 0;
            for (int i = 0; i < EpoxyModelGroup.this.models.size(); ++i) {
                EpoxyModel<?> model = EpoxyModelGroup.this.models.get(i);
                View view = useViewStubs ? this.replaceNextViewStub(groupView, model, EpoxyModelGroup.this.useViewStubLayoutParams(model, i)) : this.createAndAddView(groupView, model);
                if (model instanceof EpoxyModelWithHolder) {
                    Object holder = ((EpoxyModelWithHolder)model).createNewHolder();
                    ((EpoxyHolder)holder).bindView(view);
                    this.holders.add((EpoxyHolder)holder);
                } else {
                    this.holders.add(null);
                }
                this.views.add(view);
            }
        }

        private View createAndAddView(ViewGroup groupView, EpoxyModel<?> model) {
            View modelView = model.buildView(groupView);
            ViewGroup.LayoutParams modelLayoutParams = modelView.getLayoutParams();
            if (modelLayoutParams != null) {
                groupView.addView(modelView, modelLayoutParams);
            } else {
                groupView.addView(modelView);
            }
            return modelView;
        }

        private View replaceNextViewStub(ViewGroup groupView, EpoxyModel<?> model, boolean useStubLayoutParams) {
            ViewStubData stubData = this.getNextViewStubPosition(groupView);
            if (stubData == null) {
                throw new IllegalStateException("Your layout should provide a ViewStub for each model to be inflated into.");
            }
            stubData.viewGroup.removeView((View)stubData.viewStub);
            View modelView = model.buildView(stubData.viewGroup);
            int inflatedId = stubData.viewStub.getInflatedId();
            if (inflatedId != -1) {
                modelView.setId(inflatedId);
            }
            ViewGroup.LayoutParams modelLayoutParams = modelView.getLayoutParams();
            if (useStubLayoutParams) {
                stubData.viewGroup.addView(modelView, stubData.position, stubData.viewStub.getLayoutParams());
            } else if (modelLayoutParams != null) {
                stubData.viewGroup.addView(modelView, stubData.position, modelLayoutParams);
            } else {
                stubData.viewGroup.addView(modelView, stubData.position);
            }
            return modelView;
        }

        private ViewStubData getNextViewStubPosition(ViewGroup viewGroup) {
            int childCount = viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = viewGroup.getChildAt(i);
                if (child instanceof ViewGroup) {
                    ViewStubData nestedResult = this.getNextViewStubPosition((ViewGroup)child);
                    if (nestedResult == null) continue;
                    return nestedResult;
                }
                if (!(child instanceof ViewStub)) continue;
                return new ViewStubData(viewGroup, (ViewStub)child, i);
            }
            return null;
        }
    }

    private static interface IterateModelsCallback {
        public void onModel(EpoxyModel var1, Object var2, View var3);
    }
}

