/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.airbnb.epoxy.EpoxyHolder;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyModelWithHolder;
import com.airbnb.epoxy.GeneratedModel;
import java.util.List;

public class EpoxyViewHolder
extends RecyclerView.ViewHolder {
    private EpoxyModel epoxyModel;
    private List<Object> payloads;
    private EpoxyHolder epoxyHolder;

    public EpoxyViewHolder(View view) {
        super(view);
    }

    public void bind(EpoxyModel model, @Nullable EpoxyModel<?> previouslyBoundModel, List<Object> payloads, int position) {
        this.payloads = payloads;
        if (this.epoxyHolder == null && model instanceof EpoxyModelWithHolder) {
            this.epoxyHolder = ((EpoxyModelWithHolder)model).createNewHolder();
            this.epoxyHolder.bindView(this.itemView);
        }
        if (model instanceof GeneratedModel) {
            ((GeneratedModel)((Object)model)).handlePreBind(this, this.objectToBind(), position);
        }
        if (previouslyBoundModel != null) {
            model.bind(this.objectToBind(), previouslyBoundModel);
        } else if (payloads.isEmpty()) {
            model.bind(this.objectToBind());
        } else {
            model.bind(this.objectToBind(), payloads);
        }
        if (model instanceof GeneratedModel) {
            ((GeneratedModel)((Object)model)).handlePostBind(this.objectToBind(), position);
        }
        this.epoxyModel = model;
    }

    Object objectToBind() {
        return this.epoxyHolder != null ? this.epoxyHolder : this.itemView;
    }

    public void unbind() {
        this.assertBound();
        this.epoxyModel.unbind(this.objectToBind());
        this.epoxyModel = null;
        this.payloads = null;
    }

    public List<Object> getPayloads() {
        this.assertBound();
        return this.payloads;
    }

    public EpoxyModel<?> getModel() {
        this.assertBound();
        return this.epoxyModel;
    }

    private void assertBound() {
        if (this.epoxyModel == null) {
            throw new IllegalStateException("This holder is not currently bound.");
        }
    }

    public String toString() {
        return "EpoxyViewHolder{epoxyModel=" + this.epoxyModel + ", view=" + this.itemView + ", super=" + super.toString() + '}';
    }
}

