/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.VisibleForTesting;
import com.airbnb.epoxy.BaseEpoxyAdapter;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.HiddenEpoxyModel;
import java.util.HashMap;
import java.util.Map;

class ViewTypeManager {
    private static Map<Class, Integer> viewTypeMap;
    private EpoxyModel<?> lastModelForViewTypeLookup;

    ViewTypeManager() {
    }

    @VisibleForTesting
    void resetMapForTesting() {
        if (viewTypeMap != null) {
            viewTypeMap.clear();
        }
    }

    int getViewType(EpoxyModel<?> model) {
        this.lastModelForViewTypeLookup = model;
        return ViewTypeManager.getViewTypeInternal(model);
    }

    private static int getViewTypeInternal(EpoxyModel<?> model) {
        Integer viewType;
        int defaultViewType = model.getViewType();
        if (defaultViewType != 0) {
            return defaultViewType;
        }
        Class<?> modelClass = model.getClass();
        if (viewTypeMap == null) {
            viewTypeMap = new HashMap<Class, Integer>();
        }
        if ((viewType = viewTypeMap.get(modelClass)) == null) {
            viewType = -viewTypeMap.size() - 1;
            viewTypeMap.put(modelClass, viewType);
        }
        return viewType;
    }

    EpoxyModel<?> getModelForViewType(BaseEpoxyAdapter adapter, int viewType) {
        if (this.lastModelForViewTypeLookup != null && ViewTypeManager.getViewTypeInternal(this.lastModelForViewTypeLookup) == viewType) {
            return this.lastModelForViewTypeLookup;
        }
        adapter.onExceptionSwallowed(new IllegalStateException("Last model did not match expected view type"));
        for (EpoxyModel<?> model : adapter.getCurrentModels()) {
            if (model.getViewType() != viewType) continue;
            return model;
        }
        HiddenEpoxyModel hiddenEpoxyModel = new HiddenEpoxyModel();
        if (viewType == hiddenEpoxyModel.getViewType()) {
            return hiddenEpoxyModel;
        }
        throw new IllegalStateException("Could not find model for view type: " + viewType);
    }
}

