/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import com.airbnb.epoxy.BaseEpoxyAdapter;
import com.airbnb.epoxy.BoundViewHolders;
import com.airbnb.epoxy.ControllerModelList;
import com.airbnb.epoxy.DiffHelper;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.NotifyBlocker;
import java.util.Collections;
import java.util.List;

public final class EpoxyControllerAdapter
extends BaseEpoxyAdapter {
    private final DiffHelper diffHelper = new DiffHelper(this, true);
    private final NotifyBlocker notifyBlocker = new NotifyBlocker();
    private final EpoxyController epoxyController;
    private ControllerModelList currentModels = new ControllerModelList(20);
    private List<EpoxyModel<?>> copyOfCurrentModels;
    private int itemCount;

    EpoxyControllerAdapter(@NonNull EpoxyController epoxyController) {
        this.epoxyController = epoxyController;
        this.registerAdapterDataObserver(this.notifyBlocker);
    }

    @Override
    protected void onExceptionSwallowed(@NonNull RuntimeException exception) {
        this.epoxyController.onExceptionSwallowed(exception);
    }

    @Override
    @NonNull
    List<EpoxyModel<?>> getCurrentModels() {
        return this.currentModels;
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    void setModels(@NonNull ControllerModelList models) {
        this.itemCount = models.size();
        this.copyOfCurrentModels = null;
        this.currentModels = models;
        this.notifyBlocker.allowChanges();
        this.diffHelper.notifyModelChanges();
        this.notifyBlocker.blockChanges();
    }

    @Override
    boolean diffPayloadsEnabled() {
        return true;
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.epoxyController.onAttachedToRecyclerViewInternal(recyclerView);
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.epoxyController.onDetachedFromRecyclerViewInternal(recyclerView);
    }

    @Override
    public void onViewAttachedToWindow(@NonNull EpoxyViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        this.epoxyController.onViewAttachedToWindow(holder, holder.getModel());
    }

    @Override
    public void onViewDetachedFromWindow(@NonNull EpoxyViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        this.epoxyController.onViewDetachedFromWindow(holder, holder.getModel());
    }

    @Override
    protected void onModelBound(@NonNull EpoxyViewHolder holder, @NonNull EpoxyModel<?> model, int position, @Nullable EpoxyModel<?> previouslyBoundModel) {
        this.epoxyController.onModelBound(holder, model, position, previouslyBoundModel);
    }

    @Override
    protected void onModelUnbound(@NonNull EpoxyViewHolder holder, @NonNull EpoxyModel<?> model) {
        this.epoxyController.onModelUnbound(holder, model);
    }

    @NonNull
    public List<EpoxyModel<?>> getCopyOfModels() {
        if (this.copyOfCurrentModels == null) {
            this.copyOfCurrentModels = Collections.unmodifiableList(this.currentModels);
        }
        return this.copyOfCurrentModels;
    }

    @NonNull
    public EpoxyModel<?> getModelAtPosition(int position) {
        return (EpoxyModel)this.currentModels.get(position);
    }

    @Nullable
    public EpoxyModel<?> getModelById(long id2) {
        for (EpoxyModel<?> model : this.currentModels) {
            if (model.id() != id2) continue;
            return model;
        }
        return null;
    }

    @Override
    public int getModelPosition(@NonNull EpoxyModel<?> targetModel) {
        int size = this.currentModels.size();
        for (int i = 0; i < size; ++i) {
            EpoxyModel model = (EpoxyModel)this.currentModels.get(i);
            if (model.id() != targetModel.id()) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NonNull
    public BoundViewHolders getBoundViewHolders() {
        return super.getBoundViewHolders();
    }

    void moveModel(int fromPosition, int toPosition) {
        this.copyOfCurrentModels = null;
        this.currentModels.pauseNotifications();
        this.currentModels.add(toPosition, (EpoxyModel<?>)this.currentModels.remove(fromPosition));
        this.currentModels.resumeNotifications();
        this.notifyBlocker.allowChanges();
        this.notifyItemMoved(fromPosition, toPosition);
        this.notifyBlocker.blockChanges();
    }
}

