/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.IllegalEpoxyUsage;
import com.airbnb.epoxy.ImmutableModelException;
import java.util.List;

public abstract class EpoxyModel<T> {
    private static long idCounter = -1L;
    private long id;
    @LayoutRes
    private int layout;
    private boolean shown = true;
    boolean addedToAdapter;
    private EpoxyController firstControllerAddedTo;
    EpoxyController controllerToStageTo;
    private boolean currentlyInInterceptors;
    private int hashCodeWhenAdded;
    private boolean hasDefaultId;
    @Nullable
    private SpanSizeOverrideCallback spanSizeOverride;

    protected EpoxyModel(long id2) {
        this.id(id2);
    }

    public EpoxyModel() {
        this(idCounter--);
        this.hasDefaultId = true;
    }

    boolean hasDefaultId() {
        return this.hasDefaultId;
    }

    protected int getViewType() {
        return this.getLayout();
    }

    protected View buildView(@NonNull ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayout(), parent, false);
    }

    public void bind(@NonNull T view) {
    }

    public void bind(@NonNull T view, @NonNull List<Object> payloads) {
        this.bind(view);
    }

    public void bind(@NonNull T view, @NonNull EpoxyModel<?> previouslyBoundModel) {
        this.bind(view);
    }

    public void unbind(@NonNull T view) {
    }

    public long id() {
        return this.id;
    }

    public EpoxyModel<T> id(long id2) {
        if ((this.addedToAdapter || this.firstControllerAddedTo != null) && id2 != this.id) {
            throw new IllegalEpoxyUsage("Cannot change a model's id after it has been added to the adapter.");
        }
        this.hasDefaultId = false;
        this.id = id2;
        return this;
    }

    public EpoxyModel<T> id(Number ... ids) {
        long result = 0L;
        for (Number id2 : ids) {
            result = 31L * result + EpoxyModel.hashLong64Bit(id2.hashCode());
        }
        return this.id(result);
    }

    public EpoxyModel<T> id(long id1, long id2) {
        long result = EpoxyModel.hashLong64Bit(id1);
        result = 31L * result + EpoxyModel.hashLong64Bit(id2);
        return this.id(result);
    }

    public EpoxyModel<T> id(@NonNull CharSequence key) {
        this.id(EpoxyModel.hashString64Bit(key));
        return this;
    }

    public EpoxyModel<T> id(@NonNull CharSequence key, CharSequence ... otherKeys) {
        long result = EpoxyModel.hashString64Bit(key);
        for (CharSequence otherKey : otherKeys) {
            result = 31L * result + EpoxyModel.hashString64Bit(otherKey);
        }
        return this.id(result);
    }

    public EpoxyModel<T> id(@NonNull CharSequence key, long id2) {
        long result = EpoxyModel.hashString64Bit(key);
        result = 31L * result + EpoxyModel.hashLong64Bit(id2);
        this.id(result);
        return this;
    }

    private static long hashLong64Bit(long value) {
        value ^= value << 21;
        value ^= value >>> 35;
        value ^= value << 4;
        return value;
    }

    private static long hashString64Bit(@NonNull CharSequence str) {
        long result = -3750763034362895579L;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            result ^= (long)str.charAt(i);
            result *= 1099511628211L;
        }
        return result;
    }

    @LayoutRes
    protected abstract int getDefaultLayout();

    @NonNull
    public EpoxyModel<T> layout(@LayoutRes int layoutRes) {
        this.onMutation();
        this.layout = layoutRes;
        return this;
    }

    @LayoutRes
    public final int getLayout() {
        if (this.layout == 0) {
            return this.getDefaultLayout();
        }
        return this.layout;
    }

    @NonNull
    public EpoxyModel<T> reset() {
        this.onMutation();
        this.layout = 0;
        this.shown = true;
        return this;
    }

    public void addTo(@NonNull EpoxyController controller) {
        controller.addInternal(this);
    }

    public void addIf(boolean condition, @NonNull EpoxyController controller) {
        if (condition) {
            this.addTo(controller);
        } else if (this.controllerToStageTo != null) {
            this.controllerToStageTo.clearModelFromStaging(this);
            this.controllerToStageTo = null;
        }
    }

    public void addIf(@NonNull AddPredicate predicate, @NonNull EpoxyController controller) {
        this.addIf(predicate.addIf(), controller);
    }

    protected final void addWithDebugValidation(@NonNull EpoxyController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller cannot be null");
        }
        if (controller.isModelAddedMultipleTimes(this)) {
            throw new IllegalEpoxyUsage("This model was already added to the controller at position " + controller.getFirstIndexOfModelInBuildingList(this));
        }
        if (this.firstControllerAddedTo == null) {
            this.firstControllerAddedTo = controller;
            this.hashCodeWhenAdded = this.hashCode();
            controller.addAfterInterceptorCallback(new EpoxyController.ModelInterceptorCallback(){

                @Override
                public void onInterceptorsStarted(EpoxyController controller) {
                    EpoxyModel.this.currentlyInInterceptors = true;
                }

                @Override
                public void onInterceptorsFinished(EpoxyController controller) {
                    EpoxyModel.this.hashCodeWhenAdded = EpoxyModel.this.hashCode();
                    EpoxyModel.this.currentlyInInterceptors = false;
                }
            });
        }
    }

    boolean isDebugValidationEnabled() {
        return this.firstControllerAddedTo != null;
    }

    protected final void onMutation() {
        if (this.isDebugValidationEnabled() && !this.currentlyInInterceptors) {
            throw new ImmutableModelException(this, EpoxyModel.getPosition(this.firstControllerAddedTo, this));
        }
        if (this.controllerToStageTo != null) {
            this.controllerToStageTo.setStagedModel(this);
        }
    }

    private static int getPosition(@NonNull EpoxyController controller, @NonNull EpoxyModel<?> model) {
        if (controller.isBuildingModels()) {
            return controller.getFirstIndexOfModelInBuildingList(model);
        }
        return controller.getAdapter().getModelPosition(model);
    }

    protected final void validateStateHasNotChangedSinceAdded(String descriptionOfChange, int modelPosition) {
        if (this.isDebugValidationEnabled() && !this.currentlyInInterceptors && this.hashCodeWhenAdded != this.hashCode()) {
            throw new ImmutableModelException(this, descriptionOfChange, modelPosition);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EpoxyModel)) {
            return false;
        }
        EpoxyModel that = (EpoxyModel)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.getViewType() != that.getViewType()) {
            return false;
        }
        return this.shown == that.shown;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.getViewType();
        result = 31 * result + (this.shown ? 1 : 0);
        return result;
    }

    public int getSpanSize(int totalSpanCount, int position, int itemCount) {
        return 1;
    }

    public EpoxyModel<T> spanSizeOverride(@Nullable SpanSizeOverrideCallback spanSizeCallback) {
        this.spanSizeOverride = spanSizeCallback;
        return this;
    }

    int getSpanSizeInternal(int totalSpanCount, int position, int itemCount) {
        if (this.spanSizeOverride != null) {
            return this.spanSizeOverride.getSpanSize(totalSpanCount, position, itemCount);
        }
        return this.getSpanSize(totalSpanCount, position, itemCount);
    }

    @NonNull
    public EpoxyModel<T> show() {
        return this.show(true);
    }

    @NonNull
    public EpoxyModel<T> show(boolean show) {
        this.onMutation();
        this.shown = show;
        return this;
    }

    @NonNull
    public EpoxyModel<T> hide() {
        return this.show(false);
    }

    public boolean isShown() {
        return this.shown;
    }

    public boolean shouldSaveViewState() {
        return false;
    }

    public boolean onFailedToRecycleView(@NonNull T view) {
        return false;
    }

    public void onViewAttachedToWindow(@NonNull T view) {
    }

    public void onViewDetachedFromWindow(@NonNull T view) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id=" + this.id + ", viewType=" + this.getViewType() + ", shown=" + this.shown + ", addedToAdapter=" + this.addedToAdapter + '}';
    }

    public static interface SpanSizeOverrideCallback {
        public int getSpanSize(int var1, int var2, int var3);
    }

    public static interface AddPredicate {
        public boolean addIf();
    }
}

