/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.PluralsRes;
import android.support.annotation.StringRes;
import java.util.Arrays;

public class StringAttributeData {
    private final boolean hasDefault;
    @Nullable
    private final CharSequence defaultString;
    @StringRes
    private final int defaultStringRes;
    @Nullable
    private CharSequence string;
    @StringRes
    private int stringRes;
    @PluralsRes
    private int pluralRes;
    private int quantity;
    @Nullable
    private Object[] formatArgs;

    public StringAttributeData() {
        this.hasDefault = false;
        this.defaultString = null;
        this.defaultStringRes = 0;
    }

    public StringAttributeData(@Nullable CharSequence defaultString) {
        this.hasDefault = true;
        this.defaultString = defaultString;
        this.string = defaultString;
        this.defaultStringRes = 0;
    }

    public StringAttributeData(@StringRes int defaultStringRes) {
        this.hasDefault = true;
        this.defaultStringRes = defaultStringRes;
        this.stringRes = defaultStringRes;
        this.defaultString = null;
    }

    public void setValue(@Nullable CharSequence string) {
        this.string = string;
        this.stringRes = 0;
        this.pluralRes = 0;
    }

    public void setValue(@StringRes int stringRes) {
        this.setValue(stringRes, null);
    }

    public void setValue(@StringRes int stringRes, @Nullable Object[] formatArgs) {
        if (stringRes != 0) {
            this.stringRes = stringRes;
            this.formatArgs = formatArgs;
            this.string = null;
            this.pluralRes = 0;
        } else {
            this.handleInvalidStringRes();
        }
    }

    private void handleInvalidStringRes() {
        if (this.hasDefault) {
            if (this.defaultStringRes > 0) {
                this.setValue(this.defaultStringRes);
            } else {
                this.setValue(this.defaultString);
            }
        } else {
            throw new IllegalArgumentException("0 is an invalid value for required strings.");
        }
    }

    public void setValue(@PluralsRes int pluralRes, int quantity, @Nullable Object[] formatArgs) {
        if (pluralRes != 0) {
            this.pluralRes = pluralRes;
            this.quantity = quantity;
            this.formatArgs = formatArgs;
            this.string = null;
            this.stringRes = 0;
        } else {
            this.handleInvalidStringRes();
        }
    }

    public CharSequence toString(Context context) {
        if (this.pluralRes > 0) {
            if (this.formatArgs != null) {
                return context.getResources().getQuantityString(this.pluralRes, this.quantity, this.formatArgs);
            }
            return context.getResources().getQuantityString(this.pluralRes, this.quantity);
        }
        if (this.stringRes > 0) {
            if (this.formatArgs != null) {
                return context.getResources().getString(this.stringRes, this.formatArgs);
            }
            return context.getResources().getText(this.stringRes);
        }
        return this.string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringAttributeData)) {
            return false;
        }
        StringAttributeData that = (StringAttributeData)o;
        if (this.stringRes != that.stringRes) {
            return false;
        }
        if (this.pluralRes != that.pluralRes) {
            return false;
        }
        if (this.quantity != that.quantity) {
            return false;
        }
        if (this.string != null ? !this.string.equals(that.string) : that.string != null) {
            return false;
        }
        return Arrays.equals(this.formatArgs, that.formatArgs);
    }

    public int hashCode() {
        int result = this.string != null ? this.string.hashCode() : 0;
        result = 31 * result + this.stringRes;
        result = 31 * result + this.pluralRes;
        result = 31 * result + this.quantity;
        result = 31 * result + Arrays.hashCode(this.formatArgs);
        return result;
    }
}

