/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import com.airbnb.epoxy.BaseEpoxyAdapter;
import com.airbnb.epoxy.DiffPayload;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.ModelState;
import com.airbnb.epoxy.UpdateOp;
import com.airbnb.epoxy.UpdateOpHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DiffHelper {
    private ArrayList<ModelState> oldStateList = new ArrayList();
    private Map<Long, ModelState> oldStateMap = new HashMap<Long, ModelState>();
    private ArrayList<ModelState> currentStateList = new ArrayList();
    private Map<Long, ModelState> currentStateMap = new HashMap<Long, ModelState>();
    private final BaseEpoxyAdapter adapter;
    private final boolean immutableModels;
    private final RecyclerView.AdapterDataObserver observer = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            throw new UnsupportedOperationException("Diffing is enabled. You should use notifyModelsChanged instead of notifyDataSetChanged");
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            for (int i = positionStart; i < positionStart + itemCount; ++i) {
                ((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).hashCode = DiffHelper.this.adapter.getCurrentModels().get(i).hashCode();
            }
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            int i;
            if (itemCount == 0) {
                return;
            }
            if (itemCount == 1 || positionStart == DiffHelper.this.currentStateList.size()) {
                for (int i2 = positionStart; i2 < positionStart + itemCount; ++i2) {
                    DiffHelper.this.currentStateList.add(i2, DiffHelper.this.createStateForPosition(i2));
                }
            } else {
                ArrayList<ModelState> newModels = new ArrayList<ModelState>(itemCount);
                for (i = positionStart; i < positionStart + itemCount; ++i) {
                    newModels.add(DiffHelper.this.createStateForPosition(i));
                }
                DiffHelper.this.currentStateList.addAll(positionStart, newModels);
            }
            int size = DiffHelper.this.currentStateList.size();
            for (i = positionStart + itemCount; i < size; ++i) {
                ((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).position += itemCount;
            }
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            if (itemCount == 0) {
                return;
            }
            List modelsToRemove = DiffHelper.this.currentStateList.subList(positionStart, positionStart + itemCount);
            for (ModelState model : modelsToRemove) {
                DiffHelper.this.currentStateMap.remove(model.id);
            }
            modelsToRemove.clear();
            int size = DiffHelper.this.currentStateList.size();
            for (int i = positionStart; i < size; ++i) {
                ((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).position -= itemCount;
            }
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            if (fromPosition == toPosition) {
                return;
            }
            if (itemCount != 1) {
                throw new IllegalArgumentException("Moving more than 1 item at a time is not supported. Number of items moved: " + itemCount);
            }
            ModelState model = (ModelState)DiffHelper.this.currentStateList.remove(fromPosition);
            model.position = toPosition;
            DiffHelper.this.currentStateList.add(toPosition, model);
            if (fromPosition < toPosition) {
                for (int i = fromPosition; i < toPosition; ++i) {
                    --((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).position;
                }
            } else {
                for (int i = toPosition + 1; i <= fromPosition; ++i) {
                    ++((ModelState)((DiffHelper)DiffHelper.this).currentStateList.get((int)i)).position;
                }
            }
        }
    };

    DiffHelper(BaseEpoxyAdapter adapter, boolean immutableModels) {
        this.adapter = adapter;
        this.immutableModels = immutableModels;
        adapter.registerAdapterDataObserver(this.observer);
    }

    void notifyModelChanges() {
        UpdateOpHelper updateOpHelper = new UpdateOpHelper();
        this.buildDiff(updateOpHelper);
        this.adapter.unregisterAdapterDataObserver(this.observer);
        this.notifyChanges(updateOpHelper);
        this.adapter.registerAdapterDataObserver(this.observer);
    }

    private void notifyChanges(UpdateOpHelper opHelper) {
        block6: for (UpdateOp op : opHelper.opList) {
            switch (op.type) {
                case 0: {
                    this.adapter.notifyItemRangeInserted(op.positionStart, op.itemCount);
                    continue block6;
                }
                case 3: {
                    this.adapter.notifyItemMoved(op.positionStart, op.itemCount);
                    continue block6;
                }
                case 1: {
                    this.adapter.notifyItemRangeRemoved(op.positionStart, op.itemCount);
                    continue block6;
                }
                case 2: {
                    if (this.immutableModels && op.payloads != null) {
                        this.adapter.notifyItemRangeChanged(op.positionStart, op.itemCount, new DiffPayload(op.payloads));
                        continue block6;
                    }
                    this.adapter.notifyItemRangeChanged(op.positionStart, op.itemCount);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown type: " + op.type);
        }
    }

    private UpdateOpHelper buildDiff(UpdateOpHelper updateOpHelper) {
        boolean hasInsertions;
        this.prepareStateForDiff();
        this.collectRemovals(updateOpHelper);
        boolean bl = hasInsertions = this.oldStateList.size() - updateOpHelper.getNumRemovals() != this.currentStateList.size();
        if (hasInsertions) {
            this.collectInsertions(updateOpHelper);
        }
        this.collectMoves(updateOpHelper);
        this.collectChanges(updateOpHelper);
        this.resetOldState();
        return updateOpHelper;
    }

    private void resetOldState() {
        this.oldStateList.clear();
        this.oldStateMap.clear();
    }

    private void prepareStateForDiff() {
        this.oldStateList.clear();
        this.oldStateMap.clear();
        ArrayList<ModelState> tempList = this.oldStateList;
        this.oldStateList = this.currentStateList;
        this.currentStateList = tempList;
        Map<Long, ModelState> tempMap = this.oldStateMap;
        this.oldStateMap = this.currentStateMap;
        this.currentStateMap = tempMap;
        for (ModelState modelState : this.oldStateList) {
            modelState.pair = null;
        }
        int modelCount = this.adapter.getCurrentModels().size();
        this.currentStateList.ensureCapacity(modelCount);
        for (int i = 0; i < modelCount; ++i) {
            this.currentStateList.add(this.createStateForPosition(i));
        }
    }

    private ModelState createStateForPosition(int position) {
        EpoxyModel<?> model = this.adapter.getCurrentModels().get(position);
        model.addedToAdapter = true;
        ModelState state = ModelState.build(model, position, this.immutableModels);
        ModelState previousValue = this.currentStateMap.put(state.id, state);
        if (previousValue != null) {
            int previousPosition = previousValue.position;
            EpoxyModel<?> previousModel = this.adapter.getCurrentModels().get(previousPosition);
            throw new IllegalStateException("Two models have the same ID. ID's must be unique! Model at position " + position + ": " + model + " Model at position " + previousPosition + ": " + previousModel);
        }
        return state;
    }

    private void collectRemovals(UpdateOpHelper helper) {
        for (ModelState state : this.oldStateList) {
            state.position -= helper.getNumRemovals();
            state.pair = this.currentStateMap.get(state.id);
            if (state.pair != null) {
                state.pair.pair = state;
                continue;
            }
            helper.remove(state.position);
        }
    }

    private void collectInsertions(UpdateOpHelper helper) {
        Iterator<ModelState> oldItemIterator = this.oldStateList.iterator();
        for (ModelState itemToInsert : this.currentStateList) {
            if (itemToInsert.pair != null) {
                ModelState nextOldItem = this.getNextItemWithPair(oldItemIterator);
                if (nextOldItem == null) continue;
                nextOldItem.position += helper.getNumInsertions();
                continue;
            }
            helper.add(itemToInsert.position);
        }
    }

    private void collectChanges(UpdateOpHelper helper) {
        for (ModelState newItem : this.currentStateList) {
            boolean modelChanged;
            ModelState previousItem = newItem.pair;
            if (previousItem == null) continue;
            if (this.immutableModels) {
                if (previousItem.model.isDebugValidationEnabled()) {
                    previousItem.model.validateStateHasNotChangedSinceAdded("Model was changed before it could be diffed.", previousItem.position);
                }
                modelChanged = !previousItem.model.equals(newItem.model);
            } else {
                boolean bl = modelChanged = previousItem.hashCode != newItem.hashCode;
            }
            if (!modelChanged) continue;
            helper.update(newItem.position, previousItem.model);
        }
    }

    private void collectMoves(UpdateOpHelper helper) {
        Iterator<ModelState> oldItemIterator = this.oldStateList.iterator();
        ModelState nextOldItem = null;
        block0: for (ModelState newItem : this.currentStateList) {
            if (newItem.pair == null) {
                if (helper.moves.isEmpty()) continue;
                newItem.pairWithSelf();
            }
            if (nextOldItem == null && (nextOldItem = this.getNextItemWithPair(oldItemIterator)) == null) {
                nextOldItem = newItem.pair;
            }
            while (nextOldItem != null) {
                this.updateItemPosition(newItem.pair, helper.moves);
                this.updateItemPosition(nextOldItem, helper.moves);
                if (newItem.id == nextOldItem.id && newItem.position == nextOldItem.position) {
                    nextOldItem = null;
                    continue block0;
                }
                int newItemDistance = newItem.pair.position - newItem.position;
                int oldItemDistance = nextOldItem.pair.position - nextOldItem.position;
                if (newItemDistance == 0 && oldItemDistance == 0) {
                    nextOldItem = null;
                    continue block0;
                }
                if (oldItemDistance > newItemDistance) {
                    helper.move(nextOldItem.position, nextOldItem.pair.position);
                    nextOldItem.position = nextOldItem.pair.position;
                    nextOldItem.lastMoveOp = helper.getNumMoves();
                    nextOldItem = this.getNextItemWithPair(oldItemIterator);
                    continue;
                }
                helper.move(newItem.pair.position, newItem.position);
                newItem.pair.position = newItem.position;
                newItem.pair.lastMoveOp = helper.getNumMoves();
                continue block0;
            }
        }
    }

    private void updateItemPosition(ModelState item, List<UpdateOp> moveOps) {
        int size = moveOps.size();
        for (int i = item.lastMoveOp; i < size; ++i) {
            UpdateOp moveOp = moveOps.get(i);
            int fromPosition = moveOp.positionStart;
            int toPosition = moveOp.itemCount;
            if (item.position > fromPosition && item.position <= toPosition) {
                --item.position;
                continue;
            }
            if (item.position >= fromPosition || item.position < toPosition) continue;
            ++item.position;
        }
        item.lastMoveOp = size;
    }

    @Nullable
    private ModelState getNextItemWithPair(Iterator<ModelState> iterator) {
        ModelState nextItem = null;
        while (nextItem == null && iterator.hasNext()) {
            nextItem = iterator.next();
            if (nextItem.pair != null) continue;
            nextItem = null;
        }
        return nextItem;
    }
}

