/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import com.airbnb.epoxy.ControllerHelper;
import com.airbnb.epoxy.ControllerHelperLookup;
import com.airbnb.epoxy.ControllerModelList;
import com.airbnb.epoxy.DebugTimer;
import com.airbnb.epoxy.EpoxyControllerAdapter;
import com.airbnb.epoxy.EpoxyDiffLogger;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.IllegalEpoxyUsage;
import com.airbnb.epoxy.MainThreadExecutor;
import com.airbnb.epoxy.NoOpTimer;
import com.airbnb.epoxy.OnModelBuildFinishedListener;
import com.airbnb.epoxy.Timer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class EpoxyController {
    private static final int DELAY_TO_CHECK_ADAPTER_COUNT_MS = 3000;
    private static final Timer NO_OP_TIMER = new NoOpTimer();
    public static Handler defaultModelBuildingHandler = MainThreadExecutor.INSTANCE.handler;
    public static Handler defaultDiffingHandler = MainThreadExecutor.INSTANCE.handler;
    private static boolean filterDuplicatesDefault = false;
    private static boolean globalDebugLoggingEnabled = false;
    private final EpoxyControllerAdapter adapter;
    private EpoxyDiffLogger debugObserver;
    private int recyclerViewAttachCount = 0;
    private final Handler modelBuildHandler;
    private final List<Interceptor> interceptors = new CopyOnWriteArrayList<Interceptor>();
    private volatile boolean filterDuplicates = filterDuplicatesDefault;
    private volatile Looper buildingModelsLooper = null;
    private volatile boolean hasBuiltModelsEver;
    private Timer timer = NO_OP_TIMER;
    private final ControllerHelper helper = ControllerHelperLookup.getHelperForController(this);
    private ControllerModelList modelsBeingBuilt;
    private List<ModelInterceptorCallback> modelInterceptorCallbacks;
    private EpoxyModel<?> stagedModel;
    private volatile int requestedModelBuildType = 0;
    private final Runnable buildModelsRunnable = new Runnable(){

        @Override
        public void run() {
            EpoxyController.this.cancelPendingModelBuild();
            EpoxyController.this.buildingModelsLooper = Looper.myLooper();
            EpoxyController.this.helper.resetAutoModels();
            EpoxyController.this.modelsBeingBuilt = new ControllerModelList(EpoxyController.this.getExpectedModelCount());
            EpoxyController.this.timer.start();
            EpoxyController.this.buildModels();
            EpoxyController.this.addCurrentlyStagedModelIfExists();
            EpoxyController.this.timer.stop("Models built");
            EpoxyController.this.runInterceptors();
            EpoxyController.this.filterDuplicatesIfNeeded(EpoxyController.this.modelsBeingBuilt);
            EpoxyController.this.modelsBeingBuilt.freeze();
            EpoxyController.this.timer.start();
            EpoxyController.this.adapter.setModels(EpoxyController.this.modelsBeingBuilt);
            EpoxyController.this.timer.stop("Models diffed");
            EpoxyController.this.modelsBeingBuilt = null;
            EpoxyController.this.hasBuiltModelsEver = true;
            EpoxyController.this.buildingModelsLooper = null;
        }
    };
    private static ExceptionHandler globalExceptionHandler = new ExceptionHandler(){

        @Override
        public void onException(@NonNull EpoxyController controller, @NonNull RuntimeException exception) {
        }
    };

    public EpoxyController() {
        this(defaultModelBuildingHandler, defaultDiffingHandler);
    }

    public EpoxyController(Handler modelBuildingHandler, Handler diffingHandler) {
        this.adapter = new EpoxyControllerAdapter(this, diffingHandler);
        this.modelBuildHandler = modelBuildingHandler;
        this.setDebugLoggingEnabled(globalDebugLoggingEnabled);
    }

    public void requestModelBuild() {
        if (this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Cannot call `requestModelBuild` from inside `buildModels`");
        }
        if (this.hasBuiltModelsEver) {
            this.requestDelayedModelBuild(0);
        } else {
            this.buildModelsRunnable.run();
        }
    }

    public void addModelBuildListener(OnModelBuildFinishedListener listener) {
        this.adapter.addModelBuildListener(listener);
    }

    public void removeModelBuildListener(OnModelBuildFinishedListener listener) {
        this.adapter.removeModelBuildListener(listener);
    }

    public synchronized void requestDelayedModelBuild(int delayMs) {
        if (this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Cannot call `requestDelayedModelBuild` from inside `buildModels`");
        }
        if (this.requestedModelBuildType == 2) {
            this.cancelPendingModelBuild();
        } else if (this.requestedModelBuildType == 1) {
            return;
        }
        this.requestedModelBuildType = delayMs == 0 ? 1 : 2;
        this.modelBuildHandler.postDelayed(this.buildModelsRunnable, (long)delayMs);
    }

    public synchronized void cancelPendingModelBuild() {
        if (this.requestedModelBuildType != 0) {
            this.requestedModelBuildType = 0;
            this.modelBuildHandler.removeCallbacks(this.buildModelsRunnable);
        }
    }

    private int getExpectedModelCount() {
        int currentModelCount = this.adapter.getItemCount();
        return currentModelCount != 0 ? currentModelCount : 25;
    }

    protected abstract void buildModels();

    int getFirstIndexOfModelInBuildingList(EpoxyModel<?> model) {
        this.assertIsBuildingModels();
        int size = this.modelsBeingBuilt.size();
        for (int i = 0; i < size; ++i) {
            if (this.modelsBeingBuilt.get(i) != model) continue;
            return i;
        }
        return -1;
    }

    boolean isModelAddedMultipleTimes(EpoxyModel<?> model) {
        this.assertIsBuildingModels();
        int modelCount = 0;
        int size = this.modelsBeingBuilt.size();
        for (int i = 0; i < size; ++i) {
            if (this.modelsBeingBuilt.get(i) != model) continue;
            ++modelCount;
        }
        return modelCount > 1;
    }

    void addAfterInterceptorCallback(ModelInterceptorCallback callback) {
        this.assertIsBuildingModels();
        if (this.modelInterceptorCallbacks == null) {
            this.modelInterceptorCallbacks = new ArrayList<ModelInterceptorCallback>();
        }
        this.modelInterceptorCallbacks.add(callback);
    }

    private void runInterceptors() {
        if (!this.interceptors.isEmpty()) {
            if (this.modelInterceptorCallbacks != null) {
                for (ModelInterceptorCallback callback : this.modelInterceptorCallbacks) {
                    callback.onInterceptorsStarted(this);
                }
            }
            this.timer.start();
            for (Interceptor interceptor : this.interceptors) {
                interceptor.intercept(this.modelsBeingBuilt);
            }
            this.timer.stop("Interceptors executed");
            if (this.modelInterceptorCallbacks != null) {
                for (ModelInterceptorCallback callback : this.modelInterceptorCallbacks) {
                    callback.onInterceptorsFinished(this);
                }
                this.modelInterceptorCallbacks = null;
            }
        }
    }

    public void addInterceptor(@NonNull Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void removeInterceptor(@NonNull Interceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    protected int getModelCountBuiltSoFar() {
        this.assertIsBuildingModels();
        return this.modelsBeingBuilt.size();
    }

    private void assertIsBuildingModels() {
        if (!this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Can only call this when inside the `buildModels` method");
        }
    }

    private void assertNotBuildingModels() {
        if (this.isBuildingModels()) {
            throw new IllegalEpoxyUsage("Cannot call this from inside `buildModels`");
        }
    }

    protected void add(@NonNull EpoxyModel<?> model) {
        model.addTo(this);
    }

    protected void add(EpoxyModel<?> ... modelsToAdd) {
        this.modelsBeingBuilt.ensureCapacity(this.modelsBeingBuilt.size() + modelsToAdd.length);
        for (EpoxyModel<?> model : modelsToAdd) {
            model.addTo(this);
        }
    }

    protected void add(@NonNull List<? extends EpoxyModel<?>> modelsToAdd) {
        this.modelsBeingBuilt.ensureCapacity(this.modelsBeingBuilt.size() + modelsToAdd.size());
        for (EpoxyModel<?> model : modelsToAdd) {
            model.addTo(this);
        }
    }

    void addInternal(EpoxyModel<?> modelToAdd) {
        this.assertIsBuildingModels();
        if (modelToAdd.hasDefaultId()) {
            throw new IllegalEpoxyUsage("You must set an id on a model before adding it. Use the @AutoModel annotation if you want an id to be automatically generated for you.");
        }
        if (!modelToAdd.isShown()) {
            throw new IllegalEpoxyUsage("You cannot hide a model in an EpoxyController. Use `addIf` to conditionally add a model instead.");
        }
        this.clearModelFromStaging(modelToAdd);
        modelToAdd.controllerToStageTo = null;
        this.modelsBeingBuilt.add(modelToAdd);
    }

    void setStagedModel(EpoxyModel<?> model) {
        if (model != this.stagedModel) {
            this.addCurrentlyStagedModelIfExists();
        }
        this.stagedModel = model;
    }

    void addCurrentlyStagedModelIfExists() {
        if (this.stagedModel != null) {
            this.stagedModel.addTo(this);
        }
        this.stagedModel = null;
    }

    void clearModelFromStaging(EpoxyModel<?> model) {
        if (this.stagedModel != model) {
            this.addCurrentlyStagedModelIfExists();
        }
        this.stagedModel = null;
    }

    protected boolean isBuildingModels() {
        return this.buildingModelsLooper != null && this.buildingModelsLooper == Looper.myLooper();
    }

    private void filterDuplicatesIfNeeded(List<EpoxyModel<?>> models) {
        if (!this.filterDuplicates) {
            return;
        }
        this.timer.start();
        HashSet<Long> modelIds = new HashSet<Long>(models.size());
        ListIterator<EpoxyModel<?>> modelIterator = models.listIterator();
        while (modelIterator.hasNext()) {
            EpoxyModel<?> model = modelIterator.next();
            if (modelIds.add(model.id())) continue;
            int indexOfDuplicate = modelIterator.previousIndex();
            modelIterator.remove();
            int indexOfOriginal = this.findPositionOfDuplicate(models, model);
            EpoxyModel<?> originalModel = models.get(indexOfOriginal);
            if (indexOfDuplicate <= indexOfOriginal) {
                ++indexOfOriginal;
            }
            this.onExceptionSwallowed(new IllegalEpoxyUsage("Two models have the same ID. ID's must be unique!\nOriginal has position " + indexOfOriginal + ":\n" + originalModel + "\nDuplicate has position " + indexOfDuplicate + ":\n" + model));
        }
        this.timer.stop("Duplicates filtered");
    }

    private int findPositionOfDuplicate(List<EpoxyModel<?>> models, EpoxyModel<?> duplicateModel) {
        int size = models.size();
        for (int i = 0; i < size; ++i) {
            EpoxyModel<?> model = models.get(i);
            if (model.id() != duplicateModel.id()) continue;
            return i;
        }
        throw new IllegalArgumentException("No duplicates in list");
    }

    public void setFilterDuplicates(boolean filterDuplicates) {
        this.filterDuplicates = filterDuplicates;
    }

    public boolean isDuplicateFilteringEnabled() {
        return this.filterDuplicates;
    }

    public static void setGlobalDuplicateFilteringDefault(boolean filterDuplicatesByDefault) {
        filterDuplicatesDefault = filterDuplicatesByDefault;
    }

    public void setDebugLoggingEnabled(boolean enabled) {
        this.assertNotBuildingModels();
        if (enabled) {
            this.timer = new DebugTimer(this.getClass().getSimpleName());
            if (this.debugObserver == null) {
                this.debugObserver = new EpoxyDiffLogger(this.getClass().getSimpleName());
            }
            this.adapter.registerAdapterDataObserver(this.debugObserver);
        } else {
            this.timer = NO_OP_TIMER;
            if (this.debugObserver != null) {
                this.adapter.unregisterAdapterDataObserver(this.debugObserver);
            }
        }
    }

    public boolean isDebugLoggingEnabled() {
        return this.timer != NO_OP_TIMER;
    }

    public static void setGlobalDebugLoggingEnabled(boolean globalDebugLoggingEnabled) {
        EpoxyController.globalDebugLoggingEnabled = globalDebugLoggingEnabled;
    }

    public void moveModel(int fromPosition, int toPosition) {
        this.assertNotBuildingModels();
        this.adapter.moveModel(fromPosition, toPosition);
        this.requestDelayedModelBuild(500);
    }

    @NonNull
    public EpoxyControllerAdapter getAdapter() {
        return this.adapter;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        this.adapter.onSaveInstanceState(outState);
    }

    public void onRestoreInstanceState(@Nullable Bundle inState) {
        this.adapter.onRestoreInstanceState(inState);
    }

    @NonNull
    public GridLayoutManager.SpanSizeLookup getSpanSizeLookup() {
        return this.adapter.getSpanSizeLookup();
    }

    public void setSpanCount(int spanCount) {
        this.adapter.setSpanCount(spanCount);
    }

    public int getSpanCount() {
        return this.adapter.getSpanCount();
    }

    public boolean isMultiSpan() {
        return this.adapter.isMultiSpan();
    }

    protected void onExceptionSwallowed(@NonNull RuntimeException exception) {
        globalExceptionHandler.onException(this, exception);
    }

    public static void setGlobalExceptionHandler(@NonNull ExceptionHandler globalExceptionHandler) {
        EpoxyController.globalExceptionHandler = globalExceptionHandler;
    }

    void onAttachedToRecyclerViewInternal(RecyclerView recyclerView) {
        ++this.recyclerViewAttachCount;
        if (this.recyclerViewAttachCount > 1) {
            MainThreadExecutor.INSTANCE.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (EpoxyController.this.recyclerViewAttachCount > 1) {
                        EpoxyController.this.onExceptionSwallowed(new IllegalStateException("This EpoxyController had its adapter added to more than one ReyclerView. Epoxy does not support attaching an adapter to multiple RecyclerViews because saved state will not work properly. If you did not intend to attach your adapter to multiple RecyclerViews you may be leaking a reference to a previous RecyclerView. Make sure to remove the adapter from any previous RecyclerViews (eg if the adapter is reused in a Fragment across multiple onCreateView/onDestroyView cycles). See https://github.com/airbnb/epoxy/wiki/Avoiding-Memory-Leaks for more information."));
                    }
                }
            }, 3000L);
        }
        this.onAttachedToRecyclerView(recyclerView);
    }

    void onDetachedFromRecyclerViewInternal(RecyclerView recyclerView) {
        --this.recyclerViewAttachCount;
        this.onDetachedFromRecyclerView(recyclerView);
    }

    protected void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
    }

    protected void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
    }

    protected void onModelBound(@NonNull EpoxyViewHolder holder, @NonNull EpoxyModel<?> boundModel, int position, @Nullable EpoxyModel<?> previouslyBoundModel) {
    }

    protected void onModelUnbound(@NonNull EpoxyViewHolder holder, @NonNull EpoxyModel<?> model) {
    }

    protected void onViewAttachedToWindow(@NonNull EpoxyViewHolder holder, @NonNull EpoxyModel<?> model) {
    }

    protected void onViewDetachedFromWindow(@NonNull EpoxyViewHolder holder, @NonNull EpoxyModel<?> model) {
    }

    public static interface ExceptionHandler {
        public void onException(@NonNull EpoxyController var1, @NonNull RuntimeException var2);
    }

    public static interface Interceptor {
        public void intercept(@NonNull List<EpoxyModel<?>> var1);
    }

    static interface ModelInterceptorCallback {
        public void onInterceptorsStarted(EpoxyController var1);

        public void onInterceptorsFinished(EpoxyController var1);
    }
}

