/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.view.View;
import com.airbnb.epoxy.EpoxyModel;

public class SimpleEpoxyModel
extends EpoxyModel<View> {
    @LayoutRes
    private final int layoutRes;
    private View.OnClickListener onClickListener;
    private int spanCount = 1;

    public SimpleEpoxyModel(@LayoutRes int layoutRes) {
        this.layoutRes = layoutRes;
    }

    public SimpleEpoxyModel onClick(View.OnClickListener listener) {
        this.onClickListener = listener;
        return this;
    }

    public SimpleEpoxyModel span(int span) {
        this.spanCount = span;
        return this;
    }

    @Override
    @CallSuper
    public void bind(@NonNull View view) {
        super.bind(view);
        view.setOnClickListener(this.onClickListener);
        view.setClickable(this.onClickListener != null);
    }

    @Override
    @CallSuper
    public void unbind(@NonNull View view) {
        super.unbind(view);
        view.setOnClickListener(null);
    }

    @Override
    protected int getDefaultLayout() {
        return this.layoutRes;
    }

    @Override
    public int getSpanSize(int totalSpanCount, int position, int itemCount) {
        return this.spanCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleEpoxyModel)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleEpoxyModel that = (SimpleEpoxyModel)o;
        if (this.layoutRes != that.layoutRes) {
            return false;
        }
        if (this.spanCount != that.spanCount) {
            return false;
        }
        return this.onClickListener != null ? this.onClickListener.equals(that.onClickListener) : that.onClickListener == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.layoutRes;
        result = 31 * result + (this.onClickListener != null ? this.onClickListener.hashCode() : 0);
        result = 31 * result + this.spanCount;
        return result;
    }
}

