/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewParent;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.OnModelClickListener;
import com.airbnb.epoxy.OnModelLongClickListener;

public class WrappedEpoxyModelClickListener<T extends EpoxyModel<?>, V>
implements View.OnClickListener,
View.OnLongClickListener {
    private final OnModelClickListener<T, V> originalClickListener;
    private final OnModelLongClickListener<T, V> originalLongClickListener;

    public WrappedEpoxyModelClickListener(OnModelClickListener<T, V> clickListener) {
        if (clickListener == null) {
            throw new IllegalArgumentException("Click listener cannot be null");
        }
        this.originalClickListener = clickListener;
        this.originalLongClickListener = null;
    }

    public WrappedEpoxyModelClickListener(OnModelLongClickListener<T, V> clickListener) {
        if (clickListener == null) {
            throw new IllegalArgumentException("Click listener cannot be null");
        }
        this.originalLongClickListener = clickListener;
        this.originalClickListener = null;
    }

    public void onClick(View v) {
        EpoxyViewHolder epoxyHolder = WrappedEpoxyModelClickListener.getEpoxyHolderForChildView(v);
        if (epoxyHolder == null) {
            throw new IllegalStateException("Could not find RecyclerView holder for clicked view");
        }
        int adapterPosition = epoxyHolder.getAdapterPosition();
        if (adapterPosition != -1) {
            this.originalClickListener.onClick(epoxyHolder.getModel(), epoxyHolder.objectToBind(), v, adapterPosition);
        }
    }

    public boolean onLongClick(View v) {
        EpoxyViewHolder epoxyHolder = WrappedEpoxyModelClickListener.getEpoxyHolderForChildView(v);
        if (epoxyHolder == null) {
            throw new IllegalStateException("Could not find RecyclerView holder for clicked view");
        }
        int adapterPosition = epoxyHolder.getAdapterPosition();
        if (adapterPosition != -1) {
            return this.originalLongClickListener.onLongClick(epoxyHolder.getModel(), epoxyHolder.objectToBind(), v, adapterPosition);
        }
        return false;
    }

    @Nullable
    private static EpoxyViewHolder getEpoxyHolderForChildView(View v) {
        RecyclerView recyclerView = WrappedEpoxyModelClickListener.findParentRecyclerView(v);
        if (recyclerView == null) {
            return null;
        }
        RecyclerView.ViewHolder viewHolder = recyclerView.findContainingViewHolder(v);
        if (viewHolder == null) {
            return null;
        }
        if (!(viewHolder instanceof EpoxyViewHolder)) {
            return null;
        }
        return (EpoxyViewHolder)viewHolder;
    }

    @Nullable
    private static RecyclerView findParentRecyclerView(@Nullable View v) {
        if (v == null) {
            return null;
        }
        ViewParent parent = v.getParent();
        if (parent instanceof RecyclerView) {
            return (RecyclerView)parent;
        }
        if (parent instanceof View) {
            return WrappedEpoxyModelClickListener.findParentRecyclerView((View)parent);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WrappedEpoxyModelClickListener)) {
            return false;
        }
        WrappedEpoxyModelClickListener that = (WrappedEpoxyModelClickListener)o;
        if (this.originalClickListener != null ? !this.originalClickListener.equals(that.originalClickListener) : that.originalClickListener != null) {
            return false;
        }
        return this.originalLongClickListener != null ? this.originalLongClickListener.equals(that.originalLongClickListener) : that.originalLongClickListener == null;
    }

    public int hashCode() {
        int result = this.originalClickListener != null ? this.originalClickListener.hashCode() : 0;
        result = 31 * result + (this.originalLongClickListener != null ? this.originalLongClickListener.hashCode() : 0);
        return result;
    }
}

