/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.airbnb.epoxy.BoundViewHolders;
import com.airbnb.epoxy.DiffPayload;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.ViewHolderState;
import com.airbnb.epoxy.ViewTypeManager;
import java.util.Collections;
import java.util.List;

abstract class BaseEpoxyAdapter
extends RecyclerView.Adapter<EpoxyViewHolder> {
    private static final String SAVED_STATE_ARG_VIEW_HOLDERS = "saved_state_view_holders";
    private int spanCount = 1;
    private final ViewTypeManager viewTypeManager = new ViewTypeManager();
    private final BoundViewHolders boundViewHolders = new BoundViewHolders();
    private ViewHolderState viewHolderState = new ViewHolderState();
    private final GridLayoutManager.SpanSizeLookup spanSizeLookup = new GridLayoutManager.SpanSizeLookup(){

        public int getSpanSize(int position) {
            try {
                return BaseEpoxyAdapter.this.getModelForPosition(position).getSpanSizeInternal(BaseEpoxyAdapter.this.spanCount, position, BaseEpoxyAdapter.this.getItemCount());
            }
            catch (IndexOutOfBoundsException e) {
                BaseEpoxyAdapter.this.onExceptionSwallowed(e);
                return 1;
            }
        }
    };

    BaseEpoxyAdapter() {
        this.setHasStableIds(true);
        this.spanSizeLookup.setSpanIndexCacheEnabled(true);
    }

    protected void onExceptionSwallowed(RuntimeException exception) {
    }

    public int getItemCount() {
        return this.getCurrentModels().size();
    }

    abstract List<? extends EpoxyModel<?>> getCurrentModels();

    public boolean isEmpty() {
        return this.getCurrentModels().isEmpty();
    }

    public EpoxyViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        EpoxyModel<?> model = this.viewTypeManager.getModelForViewType(this, viewType);
        View view = model.buildView(parent);
        return new EpoxyViewHolder(view, model.shouldSaveViewState());
    }

    public void onBindViewHolder(EpoxyViewHolder holder, int position) {
        this.onBindViewHolder(holder, position, Collections.emptyList());
    }

    public void onBindViewHolder(EpoxyViewHolder holder, int position, List<Object> payloads) {
        EpoxyModel<?> modelToShow = this.getModelForPosition(position);
        EpoxyModel<?> previouslyBoundModel = null;
        if (this.diffPayloadsEnabled()) {
            previouslyBoundModel = DiffPayload.getModelFromPayload(payloads, this.getItemId(position));
        }
        holder.bind(modelToShow, previouslyBoundModel, payloads, position);
        if (payloads.isEmpty()) {
            this.viewHolderState.restore(holder);
        }
        this.boundViewHolders.put(holder);
        if (this.diffPayloadsEnabled()) {
            this.onModelBound(holder, modelToShow, position, previouslyBoundModel);
        } else {
            this.onModelBound(holder, modelToShow, position, payloads);
        }
    }

    boolean diffPayloadsEnabled() {
        return false;
    }

    protected void onModelBound(EpoxyViewHolder holder, EpoxyModel<?> model, int position, @Nullable List<Object> payloads) {
        this.onModelBound(holder, model, position);
    }

    void onModelBound(EpoxyViewHolder holder, EpoxyModel<?> model, int position, @Nullable EpoxyModel<?> previouslyBoundModel) {
        this.onModelBound(holder, model, position);
    }

    protected void onModelBound(EpoxyViewHolder holder, EpoxyModel<?> model, int position) {
    }

    protected BoundViewHolders getBoundViewHolders() {
        return this.boundViewHolders;
    }

    public int getItemViewType(int position) {
        return this.viewTypeManager.getViewType(this.getModelForPosition(position));
    }

    public long getItemId(int position) {
        return this.getCurrentModels().get(position).id();
    }

    EpoxyModel<?> getModelForPosition(int position) {
        return this.getCurrentModels().get(position);
    }

    public void onViewRecycled(EpoxyViewHolder holder) {
        this.viewHolderState.save(holder);
        this.boundViewHolders.remove(holder);
        EpoxyModel<?> model = holder.getModel();
        holder.unbind();
        this.onModelUnbound(holder, model);
    }

    protected void onModelUnbound(EpoxyViewHolder holder, EpoxyModel<?> model) {
    }

    @CallSuper
    public boolean onFailedToRecycleView(EpoxyViewHolder holder) {
        return holder.getModel().onFailedToRecycleView(holder.objectToBind());
    }

    @CallSuper
    public void onViewAttachedToWindow(EpoxyViewHolder holder) {
        holder.getModel().onViewAttachedToWindow(holder.objectToBind());
    }

    @CallSuper
    public void onViewDetachedFromWindow(EpoxyViewHolder holder) {
        holder.getModel().onViewDetachedFromWindow(holder.objectToBind());
    }

    public void onSaveInstanceState(Bundle outState) {
        for (EpoxyViewHolder holder : this.boundViewHolders) {
            this.viewHolderState.save(holder);
        }
        if (this.viewHolderState.size() > 0 && !this.hasStableIds()) {
            throw new IllegalStateException("Must have stable ids when saving view holder state");
        }
        outState.putParcelable(SAVED_STATE_ARG_VIEW_HOLDERS, (Parcelable)this.viewHolderState);
    }

    public void onRestoreInstanceState(@Nullable Bundle inState) {
        if (this.boundViewHolders.size() > 0) {
            throw new IllegalStateException("State cannot be restored once views have been bound. It should be done before adding the adapter to the recycler view.");
        }
        if (inState != null) {
            this.viewHolderState = (ViewHolderState)inState.getParcelable(SAVED_STATE_ARG_VIEW_HOLDERS);
            if (this.viewHolderState == null) {
                throw new IllegalStateException("Tried to restore instance state, but onSaveInstanceState was never called.");
            }
        }
    }

    protected int getModelPosition(EpoxyModel<?> model) {
        int size = this.getCurrentModels().size();
        for (int i = 0; i < size; ++i) {
            if (model != this.getCurrentModels().get(i)) continue;
            return i;
        }
        return -1;
    }

    public GridLayoutManager.SpanSizeLookup getSpanSizeLookup() {
        return this.spanSizeLookup;
    }

    public void setSpanCount(int spanCount) {
        this.spanCount = spanCount;
    }

    public int getSpanCount() {
        return this.spanCount;
    }

    public boolean isMultiSpan() {
        return this.spanCount > 1;
    }
}

