/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.util.AdapterListUpdateCallback;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import android.support.v7.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyModel;
import java.util.Collections;
import java.util.List;

public class DiffResult {
    @NonNull
    final List<? extends EpoxyModel<?>> previousModels;
    @NonNull
    final List<? extends EpoxyModel<?>> newModels;
    @Nullable
    final DiffUtil.DiffResult differResult;

    static DiffResult noOp(@Nullable List<? extends EpoxyModel<?>> models) {
        if (models == null) {
            models = Collections.emptyList();
        }
        return new DiffResult(models, models, null);
    }

    static DiffResult inserted(@NonNull List<? extends EpoxyModel<?>> newModels) {
        return new DiffResult(Collections.EMPTY_LIST, newModels, null);
    }

    static DiffResult clear(@NonNull List<? extends EpoxyModel<?>> previousModels) {
        return new DiffResult(previousModels, Collections.EMPTY_LIST, null);
    }

    static DiffResult diff(@NonNull List<? extends EpoxyModel<?>> previousModels, @NonNull List<? extends EpoxyModel<?>> newModels, @NonNull DiffUtil.DiffResult differResult) {
        return new DiffResult(previousModels, newModels, differResult);
    }

    private DiffResult(@NonNull List<? extends EpoxyModel<?>> previousModels, @NonNull List<? extends EpoxyModel<?>> newModels, @Nullable DiffUtil.DiffResult differResult) {
        this.previousModels = previousModels;
        this.newModels = newModels;
        this.differResult = differResult;
    }

    public void dispatchTo(RecyclerView.Adapter adapter) {
        this.dispatchTo((ListUpdateCallback)new AdapterListUpdateCallback(adapter));
    }

    public void dispatchTo(ListUpdateCallback callback) {
        if (this.differResult != null) {
            this.differResult.dispatchUpdatesTo(callback);
        } else if (this.newModels.isEmpty() && !this.previousModels.isEmpty()) {
            callback.onRemoved(0, this.previousModels.size());
        } else if (!this.newModels.isEmpty() && this.previousModels.isEmpty()) {
            callback.onInserted(0, this.newModels.size());
        }
    }
}

