/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.UpdateOp;
import java.util.ArrayList;
import java.util.List;

class UpdateOpHelper {
    final List<UpdateOp> opList = new ArrayList<UpdateOp>();
    final List<UpdateOp> moves = new ArrayList<UpdateOp>();
    private UpdateOp lastOp;
    private int numInsertions;
    private int numInsertionBatches;
    private int numRemovals;
    private int numRemovalBatches;

    UpdateOpHelper() {
    }

    void reset() {
        this.opList.clear();
        this.moves.clear();
        this.lastOp = null;
        this.numInsertions = 0;
        this.numInsertionBatches = 0;
        this.numRemovals = 0;
        this.numRemovalBatches = 0;
    }

    void add(int indexToInsert) {
        this.add(indexToInsert, 1);
    }

    void add(int startPosition, int itemCount) {
        boolean batchWithLast;
        this.numInsertions += itemCount;
        boolean bl = batchWithLast = this.isLastOp(0) && (this.lastOp.contains(startPosition) || this.lastOp.positionEnd() == startPosition);
        if (batchWithLast) {
            this.addItemsToLastOperation(itemCount, null);
        } else {
            ++this.numInsertionBatches;
            this.addNewOperation(0, startPosition, itemCount);
        }
    }

    void update(int indexToChange) {
        this.update(indexToChange, null);
    }

    void update(int indexToChange, EpoxyModel<?> payload) {
        if (this.isLastOp(2)) {
            if (this.lastOp.positionStart == indexToChange + 1) {
                this.addItemsToLastOperation(1, payload);
                this.lastOp.positionStart = indexToChange;
            } else if (this.lastOp.positionEnd() == indexToChange) {
                this.addItemsToLastOperation(1, payload);
            } else if (this.lastOp.contains(indexToChange)) {
                this.addItemsToLastOperation(0, payload);
            } else {
                this.addNewOperation(2, indexToChange, 1, payload);
            }
        } else {
            this.addNewOperation(2, indexToChange, 1, payload);
        }
    }

    void remove(int indexToRemove) {
        this.remove(indexToRemove, 1);
    }

    void remove(int startPosition, int itemCount) {
        this.numRemovals += itemCount;
        boolean batchWithLast = false;
        if (this.isLastOp(1)) {
            if (this.lastOp.positionStart == startPosition) {
                batchWithLast = true;
            } else if (this.lastOp.isAfter(startPosition) && startPosition + itemCount >= this.lastOp.positionStart) {
                this.lastOp.positionStart = startPosition;
                batchWithLast = true;
            }
        }
        if (batchWithLast) {
            this.addItemsToLastOperation(itemCount, null);
        } else {
            ++this.numRemovalBatches;
            this.addNewOperation(1, startPosition, itemCount);
        }
    }

    private boolean isLastOp(int updateType) {
        return this.lastOp != null && this.lastOp.type == updateType;
    }

    private void addNewOperation(int type, int position, int itemCount) {
        this.addNewOperation(type, position, itemCount, null);
    }

    private void addNewOperation(int type, int position, int itemCount, @Nullable EpoxyModel<?> payload) {
        this.lastOp = UpdateOp.instance(type, position, itemCount, payload);
        this.opList.add(this.lastOp);
    }

    private void addItemsToLastOperation(int numItemsToAdd, EpoxyModel<?> payload) {
        this.lastOp.itemCount += numItemsToAdd;
        this.lastOp.addPayload(payload);
    }

    void move(int from, int to) {
        this.lastOp = null;
        UpdateOp op = UpdateOp.instance(3, from, to, null);
        this.opList.add(op);
        this.moves.add(op);
    }

    int getNumRemovals() {
        return this.numRemovals;
    }

    boolean hasRemovals() {
        return this.numRemovals > 0;
    }

    int getNumInsertions() {
        return this.numInsertions;
    }

    boolean hasInsertions() {
        return this.numInsertions > 0;
    }

    int getNumMoves() {
        return this.moves.size();
    }

    int getNumInsertionBatches() {
        return this.numInsertionBatches;
    }

    int getNumRemovalBatches() {
        return this.numRemovalBatches;
    }
}

