/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.util.LongSparseArray;
import android.util.SparseArray;
import android.view.View;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.viewmodeladapter.R;
import java.util.Collection;

class ViewHolderState
extends LongSparseArray<ViewState>
implements Parcelable {
    public static final Parcelable.Creator<ViewHolderState> CREATOR = new Parcelable.Creator<ViewHolderState>(){

        public ViewHolderState[] newArray(int size) {
            return new ViewHolderState[size];
        }

        public ViewHolderState createFromParcel(Parcel source) {
            int size = source.readInt();
            ViewHolderState state = new ViewHolderState(size);
            for (int i = 0; i < size; ++i) {
                long key = source.readLong();
                ViewState value = (ViewState)source.readParcelable(ViewState.class.getClassLoader());
                state.put(key, (Object)value);
            }
            return state;
        }
    };

    ViewHolderState() {
    }

    private ViewHolderState(int size) {
        super(size);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        int size = this.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            dest.writeLong(this.keyAt(i));
            dest.writeParcelable((Parcelable)this.valueAt(i), 0);
        }
    }

    public boolean hasStateForHolder(EpoxyViewHolder holder) {
        return this.get(holder.getItemId()) != null;
    }

    public void save(Collection<EpoxyViewHolder> holders) {
        for (EpoxyViewHolder holder : holders) {
            this.save(holder);
        }
    }

    public void save(EpoxyViewHolder holder) {
        if (!holder.getModel().shouldSaveViewState()) {
            return;
        }
        ViewState state = (ViewState)((Object)this.get(holder.getItemId()));
        if (state == null) {
            state = new ViewState();
        }
        state.save(holder.itemView);
        this.put(holder.getItemId(), (Object)state);
    }

    public void restore(EpoxyViewHolder holder) {
        if (!holder.getModel().shouldSaveViewState()) {
            return;
        }
        ViewState state = (ViewState)((Object)this.get(holder.getItemId()));
        if (state != null) {
            state.restore(holder.itemView);
        }
    }

    public static class ViewState
    extends SparseArray<Parcelable>
    implements Parcelable {
        public static final Parcelable.Creator<ViewState> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<ViewState>(){

            public ViewState createFromParcel(Parcel source, ClassLoader loader) {
                int size = source.readInt();
                int[] keys = new int[size];
                source.readIntArray(keys);
                Parcelable[] values = source.readParcelableArray(loader);
                return new ViewState(size, keys, values);
            }

            public ViewState[] newArray(int size) {
                return new ViewState[size];
            }
        });

        ViewState() {
        }

        private ViewState(int size, int[] keys, Parcelable[] values) {
            super(size);
            for (int i = 0; i < size; ++i) {
                this.put(keys[i], values[i]);
            }
        }

        public void save(View view) {
            int originalId = view.getId();
            this.setIdIfNoneExists(view);
            view.saveHierarchyState((SparseArray)this);
            view.setId(originalId);
        }

        public void restore(View view) {
            int originalId = view.getId();
            this.setIdIfNoneExists(view);
            view.restoreHierarchyState((SparseArray)this);
            view.setId(originalId);
        }

        private void setIdIfNoneExists(View view) {
            if (view.getId() == -1) {
                view.setId(R.id.view_model_state_saving_id);
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            int size = this.size();
            int[] keys = new int[size];
            Parcelable[] values = new Parcelable[size];
            for (int i = 0; i < size; ++i) {
                keys[i] = this.keyAt(i);
                values[i] = (Parcelable)this.valueAt(i);
            }
            parcel.writeInt(size);
            parcel.writeIntArray(keys);
            parcel.writeParcelableArray(values, flags);
        }
    }
}

